/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.lang;

import com.google.common.base.Converter;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.beans.BeanMap;
import org.openingo.jdkits.collection.ListKit;
import org.openingo.jdkits.reflect.ClassKit;
import org.openingo.jdkits.validate.ValidateKit;

public final class BeanKit {
    private BeanKit() {
    }

    public static Map<String, Object> beanToMap(Object bean) {
        return null == bean ? null : BeanMap.create((Object)bean);
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> clazz) {
        T bean = ClassKit.newInstance(clazz);
        BeanMap.create(bean).putAll(map);
        return bean;
    }

    public static <T> List<Map<String, Object>> beansToMaps(List<T> beans) {
        if (ValidateKit.isEmpty(beans)) {
            return ListKit.emptyList();
        }
        return beans.stream().map(BeanKit::beanToMap).collect(Collectors.toList());
    }

    public static <T> List<T> mapsToBeans(List<Map<String, Object>> maps, Class<T> clazz) {
        if (ValidateKit.isEmpty(maps)) {
            return ListKit.emptyList();
        }
        return maps.stream().map(e -> BeanKit.mapToBean(e, clazz)).collect(Collectors.toList());
    }

    public static <A, B> B copy(A a, Class<B> bClass) {
        Class<?> aClass = a.getClass();
        return (B)BeanKit.converter(aClass, bClass).convert(a);
    }

    public static <A, B> List<B> copy(Collection<A> a, Class<B> bClass) {
        Class<?> aClass = a.iterator().next().getClass();
        return Lists.newArrayList((Iterable)BeanKit.converter(aClass, bClass).convertAll(a));
    }

    private static <A, B> Converter<A, B> converter(Class<A> aClass, Class<B> bClass) {
        BeanCopier a2bCopier = BeanCopier.create(aClass, bClass, (boolean)false);
        BeanCopier b2aCopier = BeanCopier.create(bClass, aClass, (boolean)false);
        return Converter.from(a -> {
            Object b = ClassKit.newInstance(bClass);
            a2bCopier.copy(a, b, null);
            return b;
        }, b -> {
            Object a = ClassKit.newInstance(aClass);
            b2aCopier.copy(b, a, null);
            return a;
        });
    }
}

