/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.lang;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class DiffPropertiesHelper {
    private static ThreadLocal<ConcurrentHashMap<String, Object>> DIFF_PROPERTIES_HOLDER = new ThreadLocal();

    public static void prepare() {
        if (null != DiffPropertiesHelper.get()) {
            return;
        }
        DIFF_PROPERTIES_HOLDER.set(new ConcurrentHashMap(20));
    }

    public static Map<String, Object> get() {
        return DIFF_PROPERTIES_HOLDER.get();
    }

    public static void clear() {
        DIFF_PROPERTIES_HOLDER.remove();
    }

    public static void addObjProperty(String objPropertyName) {
        Map<String, Object> data = DiffPropertiesHelper.get();
        if (null == data || data.containsKey(objPropertyName)) {
            return;
        }
        data.put(objPropertyName, new ConcurrentHashMap(10));
    }

    public static void put(String propertyName, Object newValue, Object oldValue) {
        Map<String, Object> data = DiffPropertiesHelper.get();
        if (null == data) {
            return;
        }
        if (null != newValue && !newValue.equals(oldValue)) {
            String[] property = propertyName.split("\\.");
            int length = property.length;
            if (length == 1) {
                data.put(propertyName, newValue);
            } else if (length == 2) {
                String tmpProperty = property[0];
                ConcurrentHashMap<String, Object> objProperty = null;
                if (data.containsKey(tmpProperty) || data.containsKey(tmpProperty = tmpProperty + "-ERROR-KEY")) {
                    objProperty = (ConcurrentHashMap<String, Object>)data.get(tmpProperty);
                } else {
                    objProperty = new ConcurrentHashMap<String, Object>(10);
                    data.put(tmpProperty, objProperty);
                }
                objProperty.put(property[1], newValue);
            }
        }
    }
}

