/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.safety;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openingo.jdkits.safety.SafetyCallable;
import org.openingo.jdkits.safety.SafetyRunnable;

public class Safety {
    private final Lock safeLock = new ReentrantLock();

    public void safetyRun(SafetyRunnable runnable) {
        this.safeLock.lock();
        try {
            runnable.run();
        }
        finally {
            this.safeLock.unlock();
        }
    }

    public <T> T safetyCall(SafetyCallable<T> callable) {
        this.safeLock.lock();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.safeLock.unlock();
        }
    }
}

