/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.redip.dictionary.remote;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import org.openingo.jdkits.validate.AssertKit;
import org.openingo.redip.configuration.RemoteConfiguration;
import org.openingo.redip.constants.DictionaryType;
import org.openingo.redip.dictionary.IDictionary;

public abstract class AbstractRemoteDictionary {
    protected final RemoteConfiguration remoteConfiguration;

    AbstractRemoteDictionary(RemoteConfiguration remoteConfiguration) {
        this.remoteConfiguration = remoteConfiguration;
    }

    public Set<String> getRemoteWords(DictionaryType dictionaryType, URI domainUri) {
        return this.getRemoteWords(dictionaryType, domainUri.getScheme(), domainUri.getAuthority());
    }

    public Set<String> getRemoteWords(DictionaryType dictionaryType, String etymology, String domain) {
        return Collections.emptySet();
    }

    protected void reloadDictionary(IDictionary dictionary, DictionaryType dictionaryType, URI domainUri) {
        this.reloadDictionary(dictionary, dictionaryType, domainUri.getAuthority());
    }

    protected void reloadDictionary(IDictionary dictionary, DictionaryType dictionaryType, String domain) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMainWord(String domain, String ... words) {
        AbstractRemoteDictionary abstractRemoteDictionary = this;
        synchronized (abstractRemoteDictionary) {
            return this.processAddingWords(DictionaryType.MAIN_WORDS, domain, words);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addStopWord(String domain, String ... words) {
        AbstractRemoteDictionary abstractRemoteDictionary = this;
        synchronized (abstractRemoteDictionary) {
            return this.processAddingWords(DictionaryType.STOP_WORDS, domain, words);
        }
    }

    private boolean processAddingWords(DictionaryType dictionaryType, String domain, String ... words) {
        AssertKit.notEmpty((Object[])words, (String)"the words is 'null' or 'empty'.");
        return this.addWord(dictionaryType, domain, words);
    }

    protected abstract boolean addWord(DictionaryType var1, String var2, String ... var3);

    protected abstract void closeResource();

    protected abstract String etymology();

    protected static enum DomainDictState {
        NEWLY("newly"),
        NON_NEWLY("non-newly"),
        NOT_FOUND("not-found");

        String state;

        private DomainDictState(String state) {
            this.state = state;
        }

        static DomainDictState newByState(String state) {
            return Stream.of(DomainDictState.values()).filter(s -> s.state.equals(state)).findFirst().orElse(NOT_FOUND);
        }
    }
}

