/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.redip.dictionary.remote;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.http.util.Asserts;
import org.openingo.redip.configuration.RedipConfigurationProperties;
import org.openingo.redip.constants.DictionaryType;
import org.openingo.redip.constants.RemoteDictionaryEtymology;
import org.openingo.redip.dictionary.IDictionary;
import org.openingo.redip.dictionary.remote.AbstractRemoteDictionary;
import org.openingo.redip.dictionary.remote.HttpRemoteDictionary;
import org.openingo.redip.dictionary.remote.MySQLRemoteDictionary;
import org.openingo.redip.dictionary.remote.RedisRemoteDictionary;
import org.openingo.redip.helper.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteDictionary {
    private static final Logger log = LoggerFactory.getLogger(RemoteDictionary.class);
    private static RemoteDictionary remoteDictionaryHandler;
    private static final Map<String, AbstractRemoteDictionary> REMOTE_DICTIONARY;

    private RemoteDictionary() {
    }

    private static void checkInitial() {
        Asserts.notNull((Object)remoteDictionaryHandler, (String)"The RemoteDictionary is not initial.");
    }

    public static void initial(RedipConfigurationProperties properties) {
        RedipConfigurationProperties.Remote remoteConfiguration = properties.getRemote();
        RemoteDictionary.initial();
        RemoteDictionary.addRemoteDictionary(new HttpRemoteDictionary(remoteConfiguration));
        RemoteDictionary.addRemoteDictionary(new RedisRemoteDictionary(remoteConfiguration));
        RemoteDictionary.addRemoteDictionary(new MySQLRemoteDictionary(remoteConfiguration));
        log.info("Remote Dictionary Initialed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initial() {
        if (!Objects.isNull(remoteDictionaryHandler)) return;
        Class<RemoteDictionary> clazz = RemoteDictionary.class;
        synchronized (RemoteDictionary.class) {
            if (!Objects.isNull(remoteDictionaryHandler)) return;
            remoteDictionaryHandler = new RemoteDictionary();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void addRemoteDictionary(AbstractRemoteDictionary remoteDictionary) {
        RemoteDictionary.checkInitial();
        String etymology = remoteDictionary.etymology();
        if (!REMOTE_DICTIONARY.containsKey(etymology)) {
            REMOTE_DICTIONARY.put(etymology, remoteDictionary);
        }
        log.info("The Remote Dictionary For etymology '{}' is loaded!", (Object)etymology);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getRemoteWords(DictionaryType dictionaryType, URI domainUri) {
        RemoteDictionary.checkInitial();
        log.info("begin to get remote dictionary words...");
        AbstractRemoteDictionary remoteDictionary = RemoteDictionary.getRemoteDictionary(domainUri);
        Set remoteWords = Collections.emptySet();
        if (Objects.isNull(remoteDictionary)) {
            log.info("the remote dictionary for '{}' not found.", (Object)domainUri);
            return remoteWords;
        }
        Class<RemoteDictionary> clazz = RemoteDictionary.class;
        synchronized (RemoteDictionary.class) {
            remoteWords = AccessController.doPrivileged(() -> remoteDictionary.getRemoteWords(dictionaryType, domainUri));
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return StringHelper.filterBlank(remoteWords);
        }
    }

    public static Set<String> getRemoteWords(RemoteDictionaryEtymology etymology, DictionaryType dictionaryType, String domain) {
        return RemoteDictionary.getRemoteWords(dictionaryType, URI.create(String.format("%s://%s", etymology.getEtymology(), domain)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadRemoteDictionary(IDictionary dictionary, DictionaryType dictionaryType, URI domainUri) {
        RemoteDictionary.checkInitial();
        AbstractRemoteDictionary remoteDictionary = RemoteDictionary.getRemoteDictionary(domainUri);
        if (Objects.isNull(remoteDictionary)) {
            return;
        }
        Class<RemoteDictionary> clazz = RemoteDictionary.class;
        synchronized (RemoteDictionary.class) {
            AccessController.doPrivileged(() -> {
                remoteDictionary.reloadDictionary(dictionary, dictionaryType, domainUri);
                return null;
            });
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static boolean addWord(DictionaryType dictionaryType, URI domainUri, String ... words) {
        RemoteDictionaryEtymology etymology = RemoteDictionaryEtymology.newEtymology(domainUri.getScheme());
        return RemoteDictionary.addWord(etymology, dictionaryType, domainUri.getAuthority(), words);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addWord(RemoteDictionaryEtymology etymology, DictionaryType dictionaryType, String domain, String ... words) {
        RemoteDictionary.checkInitial();
        AbstractRemoteDictionary dictionary = REMOTE_DICTIONARY.get(etymology.getEtymology());
        Class<RemoteDictionary> clazz = RemoteDictionary.class;
        synchronized (RemoteDictionary.class) {
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return dictionary.addWord(dictionaryType, domain, words);
        }
    }

    private static URI toUri(String location) {
        URI uri;
        try {
            uri = new URI(location);
            log.info("schema {} authority {}", (Object)uri.getScheme(), (Object)uri.getAuthority());
        }
        catch (URISyntaxException e) {
            log.error("parser location to uri error {} ", (Object)e.getLocalizedMessage());
            throw new IllegalArgumentException(String.format("the location %s is illegal: %s", location, e.getLocalizedMessage()));
        }
        return uri;
    }

    private static AbstractRemoteDictionary getRemoteDictionary(URI uri) {
        String etymology = uri.getScheme();
        log.info("Remote Dictionary etymology '{}'", (Object)etymology);
        AbstractRemoteDictionary remoteDictionary = REMOTE_DICTIONARY.get(etymology);
        if (Objects.isNull(remoteDictionary)) {
            log.info("the remote dictionary for '{}' not found.", (Object)uri);
        }
        return remoteDictionary;
    }

    static {
        REMOTE_DICTIONARY = new HashMap<String, AbstractRemoteDictionary>();
    }
}

