/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.redip.dictionary.remote;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.openingo.jdkits.lang.StrKit;
import org.openingo.redip.configuration.RemoteConfiguration;
import org.openingo.redip.constants.DictionaryType;
import org.openingo.redip.constants.RemoteDictionaryEtymology;
import org.openingo.redip.dictionary.IDictionary;
import org.openingo.redip.dictionary.remote.AbstractRemoteDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpRemoteDictionary
extends AbstractRemoteDictionary {
    private static final Logger log = LoggerFactory.getLogger(HttpRemoteDictionary.class);
    private static final CloseableHttpClient HTTP_CLIENT = HttpClients.createDefault();
    private static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(15000).build();
    private static final Map<String, Modifier> MODIFIER_MAPPING = new ConcurrentHashMap<String, Modifier>();

    public HttpRemoteDictionary(RemoteConfiguration remoteConfiguration) {
        super(remoteConfiguration);
    }

    @Override
    protected boolean addWord(DictionaryType dictionaryType, String domain, String ... words) {
        log.info("'{}' remote dictionary add new word 'not support", (Object)this.etymology());
        return false;
    }

    @Override
    protected void closeResource() {
    }

    @Override
    public Set<String> getRemoteWords(DictionaryType dictionaryType, URI domainUri) {
        String location = this.getLocation(dictionaryType, domainUri);
        log.info("'http' remote dictionary get new words from domain '{}' dictionary '{}' location '{}'", new Object[]{domainUri, dictionaryType, location});
        HashSet<String> words = new HashSet<String>();
        HttpGet get = new HttpGet(location);
        get.setConfig(REQUEST_CONFIG);
        try {
            CloseableHttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                String charset = "UTF-8";
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String string;
                    String typeValue;
                    Header contentType = entity.getContentType();
                    if (contentType != null && contentType.getValue() != null && (typeValue = contentType.getValue()) != null && typeValue.contains("charset=")) {
                        charset = typeValue.substring(typeValue.lastIndexOf("=") + 1);
                    }
                    if (StrKit.notBlank((String)(string = EntityUtils.toString((HttpEntity)entity, (String)charset)))) {
                        words.addAll(Arrays.asList(string.split("\n|\r\n")));
                    }
                }
            }
            response.close();
        }
        catch (IOException | IllegalStateException e) {
            log.error("getRemoteWords error '{}' location '{}'", (Object)e, (Object)location);
        }
        return words;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reloadDictionary(IDictionary dictionary, DictionaryType dictionaryType, URI domainUri) {
        String location = this.getLocation(dictionaryType, domainUri);
        log.info("'http' remote dictionary reload dictionary from domain '{}' dictionary '{}' location '{}'", new Object[]{domainUri, dictionaryType, location});
        HttpHead head = new HttpHead(location);
        head.setConfig(REQUEST_CONFIG);
        String lastModified = null;
        String eTags = null;
        Modifier modifier = MODIFIER_MAPPING.get(location);
        if (Objects.nonNull(modifier)) {
            lastModified = modifier.lastModified;
            eTags = modifier.eTags;
        }
        if (lastModified != null) {
            head.setHeader("If-Modified-Since", lastModified);
        }
        if (eTags != null) {
            head.setHeader("If-None-Match", eTags);
        }
        CloseableHttpResponse response = null;
        try {
            response = HTTP_CLIENT.execute((HttpUriRequest)head);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 304) {
                log.info("[Remote DictFile Reloading] Not modified!");
                return;
            }
            if (statusCode == 200) {
                boolean needReload;
                Header lastHeader = response.getLastHeader("Last-Modified");
                Header eTag = response.getLastHeader("ETag");
                boolean bl = needReload = Objects.nonNull(lastHeader) && !lastHeader.getValue().equalsIgnoreCase(lastModified) || Objects.nonNull(eTag) && !eTag.getValue().equalsIgnoreCase(eTags);
                if (needReload) {
                    dictionary.reload(dictionaryType);
                    lastModified = Objects.isNull(lastHeader) ? null : lastHeader.getValue();
                    eTags = Objects.isNull(eTag) ? null : eTag.getValue();
                    MODIFIER_MAPPING.put(location, new Modifier(lastModified, eTags));
                }
                return;
            }
            log.info("remote_ext_dict '{}' return bad code '{}'", (Object)location, (Object)statusCode);
        }
        catch (Exception e) {
            log.error("remote_ext_dict error '{}' location '{}' !", (Object)e, (Object)location);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                log.error("remote_ext_dict response close error", (Throwable)e);
            }
        }
    }

    @Override
    public String etymology() {
        return RemoteDictionaryEtymology.HTTP.getEtymology();
    }

    private String getLocation(DictionaryType dictionaryType, URI domainUri) {
        String schemeSpecificPart = domainUri.getSchemeSpecificPart();
        if (schemeSpecificPart.startsWith("http") || schemeSpecificPart.startsWith("https")) {
            return schemeSpecificPart;
        }
        RemoteConfiguration.Http http = this.remoteConfiguration.http();
        return String.format("%s/es-dict/%s/%s", http.getBase(), dictionaryType.getDictName(), domainUri.getAuthority());
    }

    static class Modifier {
        String lastModified;
        String eTags;

        public Modifier(String lastModified, String eTags) {
            this.lastModified = lastModified;
            this.eTags = eTags;
        }

        public Modifier() {
        }
    }
}

