/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.redip.dictionary.remote;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openingo.jdkits.sys.SystemClockKit;
import org.openingo.redip.configuration.RemoteConfiguration;
import org.openingo.redip.constants.DictionaryType;
import org.openingo.redip.constants.RemoteDictionaryEtymology;
import org.openingo.redip.dictionary.IDictionary;
import org.openingo.redip.dictionary.remote.AbstractRemoteDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisRemoteDictionary
extends AbstractRemoteDictionary {
    private static final Logger log = LoggerFactory.getLogger(RedisRemoteDictionary.class);
    private final StatefulRedisConnection<String, String> redisConnection = this.getRedisConnection();
    private static final String KEY_PREFIX = "es-ik-words";

    public RedisRemoteDictionary(RemoteConfiguration remoteConfiguration) {
        super(remoteConfiguration);
    }

    @Override
    public Set<String> getRemoteWords(DictionaryType dictionaryType, String etymology, String domain) {
        log.info("'redis' remote dictionary get new words from domain '{}' dictionary '{}'", (Object)domain, (Object)dictionaryType);
        RedisCommands sync = this.redisConnection.sync();
        String key = this.getKey(dictionaryType, domain);
        List words = sync.zrange((Object)key, 0L, -1L);
        this.resetState(dictionaryType, domain);
        return new HashSet<String>(words);
    }

    @Override
    protected void reloadDictionary(IDictionary dictionary, DictionaryType dictionaryType, String domain) {
        log.info("'redis' remote dictionary reload dictionary from domain '{}' dictionary '{}'", (Object)domain, (Object)dictionaryType);
        boolean reload = this.resetState(dictionaryType, domain);
        if (reload) {
            dictionary.reload(dictionaryType);
        }
    }

    private boolean resetState(DictionaryType dictionaryType, String domain) {
        RedisCommands sync = this.redisConnection.sync();
        String key = this.getKey(dictionaryType, domain);
        String state = this.getStateKey(key);
        String currentState = (String)sync.get((Object)state);
        AbstractRemoteDictionary.DomainDictState domainDictState = AbstractRemoteDictionary.DomainDictState.newByState(currentState);
        log.info("'redis' remote dictionary state '{}' = '{}' for domain '{}'.", new Object[]{state, currentState, domain});
        if (!AbstractRemoteDictionary.DomainDictState.NEWLY.equals((Object)domainDictState)) {
            return false;
        }
        sync.set((Object)state, (Object)AbstractRemoteDictionary.DomainDictState.NON_NEWLY.state);
        return true;
    }

    @Override
    protected boolean addWord(DictionaryType dictionaryType, String domain, String ... words) {
        log.info("'redis' remote dictionary add new word '{}' for dictionary '{}'", (Object)words, (Object)dictionaryType);
        RedisCommands sync = this.redisConnection.sync();
        sync.multi();
        String key = this.getKey(dictionaryType, domain);
        ArrayList<ScoredValue> scoresAndValues = new ArrayList<ScoredValue>(words.length * 2);
        for (int i = 0; i < words.length; ++i) {
            scoresAndValues.add(ScoredValue.just((double)((double)SystemClockKit.now() * 1.0 + (double)i), (Object)words[i]));
        }
        sync.zadd((Object)key, scoresAndValues.toArray());
        String state = this.getStateKey(key);
        sync.set((Object)state, (Object)AbstractRemoteDictionary.DomainDictState.NEWLY.state);
        TransactionResult transactionResult = sync.exec();
        for (Object txRet : transactionResult) {
            log.info("txRet '{}'", txRet);
        }
        log.info("'{} add new word '{}' success.", (Object)this.etymology(), (Object)words);
        return true;
    }

    @Override
    protected void closeResource() {
        if (Objects.isNull(this.redisConnection) || !this.redisConnection.isOpen()) {
            return;
        }
        String etymology = this.etymology();
        log.info("'{}' remote dictionary is closing...", (Object)etymology);
        this.redisConnection.close();
        log.info("'{}' remote dictionary is closed", (Object)etymology);
    }

    @Override
    protected String etymology() {
        return RemoteDictionaryEtymology.REDIS.getEtymology();
    }

    private String getStateKey(String key) {
        return String.format("%s:state", key);
    }

    private String getKey(DictionaryType dictionaryType, String domain) {
        return String.format("%s:%s:%s", KEY_PREFIX, domain, dictionaryType.getDictName());
    }

    private StatefulRedisConnection<String, String> getRedisConnection() {
        RemoteConfiguration.Redis redis = this.remoteConfiguration.getRedis();
        RedisURI.Builder builder = RedisURI.builder().withHost(redis.getHost()).withPort(redis.getPort().intValue()).withDatabase(redis.getDatabase().intValue());
        String username = redis.getUsername();
        String password = redis.getPassword();
        if (Objects.nonNull(username) && Objects.nonNull(password)) {
            builder.withAuthentication(redis.getUsername(), password.toCharArray());
        } else if (Objects.nonNull(password)) {
            builder.withPassword(password.toCharArray());
        }
        return RedisClient.create((RedisURI)builder.build()).connect();
    }
}

