/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.redip.dictionary.remote;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.openingo.redip.configuration.RemoteConfiguration;
import org.openingo.redip.constants.DictionaryType;
import org.openingo.redip.constants.RemoteDictionaryEtymology;
import org.openingo.redip.dictionary.IDictionary;
import org.openingo.redip.dictionary.remote.AbstractRemoteDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLRemoteDictionary
extends AbstractRemoteDictionary {
    private static final Logger log = LoggerFactory.getLogger(MySQLRemoteDictionary.class);
    private final HikariDataSource dataSource = this.initDataSource();

    public MySQLRemoteDictionary(RemoteConfiguration remoteConfiguration) {
        super(remoteConfiguration);
    }

    @Override
    public Set<String> getRemoteWords(DictionaryType dictionaryType, String etymology, String domain) {
        log.info("'mysql' remote dictionary get new words from domain '{}' dictionary '{}'", (Object)domain, (Object)dictionaryType);
        HashSet<String> words = new HashSet<String>();
        try (Connection connection = this.dataSource.getConnection();){
            String sql = "SELECT word FROM ik_words WHERE domain = ? AND word_type = ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, domain);
            statement.setInt(2, dictionaryType.getType());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String word = resultSet.getString("word");
                words.add(word);
            }
            log.info("'mysql' remote dictionary append '{}' words.", (Object)words.size());
            log.info("'mysql' remote dictionary update dictionary state from domain '{}' dictionary '{}'", (Object)domain, (Object)dictionaryType);
            this.resetState(connection, domain);
            statement.close();
            resultSet.close();
        }
        catch (SQLException e) {
            log.error("'mysql' remote dictionary error =>", (Throwable)e);
        }
        return words;
    }

    @Override
    protected void reloadDictionary(IDictionary dictionary, DictionaryType dictionaryType, String domain) {
        log.info("'mysql' remote dictionary reload dictionary from domain '{}' dictionary '{}'", (Object)domain, (Object)dictionaryType);
        try (Connection connection = this.dataSource.getConnection();){
            boolean reload = this.resetState(connection, domain);
            if (reload) {
                dictionary.reload(dictionaryType);
            }
        }
        catch (SQLException e) {
            log.error("'mysql' remote dictionary error =>", (Throwable)e);
        }
    }

    protected boolean resetState(Connection connection, String domain) throws SQLException {
        AbstractRemoteDictionary.DomainDictState state = this.getState(connection, domain);
        log.info("'mysql' remote dictionary domain '{}' state '{}'", (Object)domain, (Object)state);
        if (!AbstractRemoteDictionary.DomainDictState.NEWLY.equals((Object)state)) {
            return false;
        }
        String sql = "UPDATE ik_dict_state SET state = ? WHERE domain = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, AbstractRemoteDictionary.DomainDictState.NON_NEWLY.state);
        preparedStatement.setString(2, domain);
        log.info("update ik_dict_state sql '{}'", (Object)sql);
        preparedStatement.execute();
        preparedStatement.close();
        return true;
    }

    @Override
    protected boolean addWord(DictionaryType dictionaryType, String domain, String ... words) {
        log.info("'{}' remote dictionary add new word '{}' for dictionary '{}'", new Object[]{this.etymology(), words, dictionaryType});
        boolean ret = true;
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(false);
            String sql = "INSERT INTO ik_words(word, word_type, domain) VALUES (?, ?, ?)";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                Integer dictionaryTypeType = dictionaryType.getType();
                for (String word : words) {
                    statement.setString(1, word);
                    statement.setInt(2, dictionaryTypeType);
                    statement.setString(3, domain);
                    statement.addBatch();
                }
                statement.executeBatch();
                AbstractRemoteDictionary.DomainDictState state = this.getState(connection, domain);
                log.info("'mysql' remote dictionary domain '{}' state '{}'", (Object)domain, (Object)state);
                AbstractRemoteDictionary.DomainDictState domainState = null;
                if (AbstractRemoteDictionary.DomainDictState.NON_NEWLY.equals((Object)state)) {
                    sql = "UPDATE ik_dict_state SET state = ? WHERE domain = ?";
                    domainState = AbstractRemoteDictionary.DomainDictState.NEWLY;
                }
                if (AbstractRemoteDictionary.DomainDictState.NOT_FOUND.equals((Object)state)) {
                    sql = "INSERT INTO ik_dict_state(state, domain) VALUES(?, ?)";
                    domainState = AbstractRemoteDictionary.DomainDictState.NEWLY;
                }
                if (Objects.nonNull((Object)domainState)) {
                    PreparedStatement preparedStatement = connection.prepareStatement(sql);
                    preparedStatement.setString(1, domainState.state);
                    preparedStatement.setString(2, domain);
                    preparedStatement.execute();
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                connection.rollback();
                connection.setAutoCommit(true);
                throw e;
            }
            connection.commit();
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error("'{} add new word '{}' failure '{}'.", new Object[]{this.etymology(), words, e});
            ret = false;
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractRemoteDictionary.DomainDictState getState(Connection connection, String domain) {
        AbstractRemoteDictionary.DomainDictState state = AbstractRemoteDictionary.DomainDictState.NOT_FOUND;
        String sql = "SELECT state FROM ik_dict_state WHERE domain = ? LIMIT 1";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, domain);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) {
                    log.info("Cannot find the `ik_dict_state` for domain '{}' data", (Object)domain);
                    AbstractRemoteDictionary.DomainDictState domainDictState = state;
                    return domainDictState;
                }
                state = AbstractRemoteDictionary.DomainDictState.newByState(resultSet.getString("state"));
                return state;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error("'{} add get domain '{}' state failure '{}'.", new Object[]{this.etymology(), domain, e});
        }
        return state;
    }

    @Override
    protected void closeResource() {
        if (Objects.isNull(this.dataSource) || this.dataSource.isClosed()) {
            return;
        }
        String etymology = this.etymology();
        log.info("'{}' remote dictionary is closing...", (Object)etymology);
        this.dataSource.close();
        log.info("'{}' remote dictionary is closed", (Object)etymology);
    }

    @Override
    protected String etymology() {
        return RemoteDictionaryEtymology.MYSQL.getEtymology();
    }

    private HikariDataSource initDataSource() {
        HikariDataSource dataSource = new HikariDataSource();
        RemoteConfiguration.MySQL mysql = this.remoteConfiguration.getMysql();
        dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
        dataSource.setJdbcUrl(mysql.getUrl());
        dataSource.setUsername(mysql.getUsername());
        dataSource.setPassword(mysql.getPassword());
        return dataSource;
    }
}

