/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.redip.dictionary.remote;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisSortedSetCommands;
import io.lettuce.core.api.sync.RedisStringCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openingo.jdkits.sys.SystemClockKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.redip.configuration.RemoteConfiguration;
import org.openingo.redip.constants.DictionaryType;
import org.openingo.redip.constants.RemoteDictionaryEtymology;
import org.openingo.redip.dictionary.IDictionary;
import org.openingo.redip.dictionary.remote.AbstractRemoteDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisRemoteDictionary
extends AbstractRemoteDictionary {
    private static final Logger log = LoggerFactory.getLogger(RedisRemoteDictionary.class);
    private final StatefulRedisConnection<String, String> redisConnection;
    private final StatefulRedisClusterConnection<String, String> redisClusterConnection;
    private static final String KEY_PREFIX = "es-ik-words";

    public RedisRemoteDictionary(RemoteConfiguration remoteConfiguration) {
        super(remoteConfiguration);
        RemoteConfiguration.Redis redis = this.remoteConfiguration.getRedis();
        this.redisClusterConnection = this.getRedisClusterConnection(redis);
        this.redisConnection = this.getRedisConnection(redis);
    }

    @Override
    public Set<String> getRemoteWords(DictionaryType dictionaryType, String etymology, String domain) {
        log.info("'redis' remote dictionary get new words from domain '{}' dictionary '{}'", (Object)domain, (Object)dictionaryType);
        RedisSortedSetCommands sync = (RedisSortedSetCommands)this.getCommands();
        String key = this.getKey(dictionaryType, domain);
        List words = sync.zrange((Object)key, 0L, -1L);
        this.resetState(dictionaryType, domain);
        return new HashSet<String>(words);
    }

    @Override
    protected void reloadDictionary(IDictionary dictionary, DictionaryType dictionaryType, String domain) {
        log.info("'redis' remote dictionary reload dictionary from domain '{}' dictionary '{}'", (Object)domain, (Object)dictionaryType);
        boolean reload = this.resetState(dictionaryType, domain);
        if (reload) {
            dictionary.reload(dictionaryType);
        }
    }

    private boolean resetState(DictionaryType dictionaryType, String domain) {
        RedisStringCommands sync = (RedisStringCommands)this.getCommands();
        String key = this.getKey(dictionaryType, domain);
        String state = this.getStateKey(key);
        String currentState = (String)sync.get((Object)state);
        AbstractRemoteDictionary.DomainDictState domainDictState = AbstractRemoteDictionary.DomainDictState.newByState(currentState);
        log.info("'redis' remote dictionary state '{}' = '{}' for domain '{}'.", new Object[]{state, currentState, domain});
        if (!AbstractRemoteDictionary.DomainDictState.NEWLY.equals((Object)domainDictState)) {
            return false;
        }
        sync.set((Object)state, (Object)AbstractRemoteDictionary.DomainDictState.NON_NEWLY.state);
        return true;
    }

    @Override
    protected boolean addWord(DictionaryType dictionaryType, String domain, String ... words) {
        log.info("'redis' remote dictionary add new word '{}' for dictionary '{}'", (Object)words, (Object)dictionaryType);
        RedisSortedSetCommands sync = (RedisSortedSetCommands)this.getCommands();
        String key = this.getKey(dictionaryType, domain);
        ArrayList<ScoredValue> scoresAndValues = new ArrayList<ScoredValue>(words.length * 2);
        for (int i = 0; i < words.length; ++i) {
            scoresAndValues.add(ScoredValue.just((double)((double)SystemClockKit.now() * 1.0 + (double)i), (Object)words[i]));
        }
        sync.zadd((Object)key, scoresAndValues.toArray());
        String state = this.getStateKey(key);
        ((RedisStringCommands)sync).set((Object)state, (Object)AbstractRemoteDictionary.DomainDictState.NEWLY.state);
        log.info("'{} add new word '{}' success.", (Object)this.etymology(), (Object)words);
        return true;
    }

    @Override
    protected void closeResource() {
        StatefulRedisClusterConnection<String, String> connection = this.redisClusterConnection;
        if (Objects.isNull(connection)) {
            connection = this.redisConnection;
        }
        if (Objects.isNull(connection) || !connection.isOpen()) {
            return;
        }
        String etymology = this.etymology();
        log.info("'{}' remote dictionary is closing...", (Object)etymology);
        connection.close();
        log.info("'{}' remote dictionary is closed", (Object)etymology);
    }

    @Override
    protected String etymology() {
        return RemoteDictionaryEtymology.REDIS.getEtymology();
    }

    private String getStateKey(String key) {
        return String.format("%s:state", key);
    }

    private String getKey(DictionaryType dictionaryType, String domain) {
        return String.format("%s:%s:%s", KEY_PREFIX, domain, dictionaryType.getDictName());
    }

    private <T> T getCommands() {
        if (Objects.nonNull(this.redisClusterConnection)) {
            log.info("using cluster connection");
            return (T)this.redisClusterConnection.sync();
        }
        log.info("using standalone connection");
        return (T)this.redisConnection.sync();
    }

    private StatefulRedisClusterConnection<String, String> getRedisClusterConnection(RemoteConfiguration.Redis redis) {
        RemoteConfiguration.Redis.Cluster cluster = redis.getCluster();
        List<String> nodes = null;
        if (Objects.nonNull(cluster) && ValidateKit.isNotEmpty(nodes = cluster.getNodes())) {
            ArrayList initialUris = new ArrayList();
            nodes.stream().filter(ValidateKit::isNotEmpty).forEach(node -> {
                String[] hostPort = node.split(":");
                if (ValidateKit.isNull((Object)hostPort) || hostPort.length != 2) {
                    return;
                }
                initialUris.add(this.getRedisUri(redis, hostPort[0], Integer.parseInt(hostPort[1])));
            });
            if (ValidateKit.isNotEmpty(initialUris)) {
                return RedisClusterClient.create(initialUris).connect();
            }
        }
        return null;
    }

    private StatefulRedisConnection<String, String> getRedisConnection(RemoteConfiguration.Redis redis) {
        if (Objects.nonNull(this.redisClusterConnection)) {
            return null;
        }
        return RedisClient.create((RedisURI)this.getRedisUri(redis, redis.getHost(), redis.getPort())).connect();
    }

    private RedisURI getRedisUri(RemoteConfiguration.Redis redis, String host, Integer port) {
        RedisURI.Builder builder = RedisURI.builder().withHost(host).withPort(port.intValue()).withSsl(redis.isSsl()).withDatabase(redis.getDatabase().intValue());
        String username = redis.getUsername();
        String password = redis.getPassword();
        if (Objects.nonNull(username) && Objects.nonNull(password)) {
            builder.withAuthentication(redis.getUsername(), password.toCharArray());
        } else if (Objects.nonNull(password)) {
            builder.withPassword(password.toCharArray());
        }
        return builder.build();
    }
}

