/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.morphia.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import org.openingo.morphia.config.MorphiaConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MorphiaConfig.class})
public class MorphiaAutoConfiguration {
    private final MorphiaConfig morphiaConfig;

    public MorphiaAutoConfiguration(MorphiaConfig morphiaConfig) {
        this.morphiaConfig = morphiaConfig;
    }

    @Bean
    @ConditionalOnMissingBean(value={Datastore.class})
    public Datastore datastore() {
        MongoClient mongoClient;
        Morphia morphia = new Morphia();
        if (this.morphiaConfig.getMapPackage() != null) {
            morphia.mapPackage(this.morphiaConfig.getMapPackage());
        }
        MongoClientOptions options = new MongoClientOptions.Builder().build();
        if (this.morphiaConfig.getUsername() != null && this.morphiaConfig.getPassword() != null) {
            MongoCredential credential = MongoCredential.createCredential((String)this.morphiaConfig.getUsername(), (String)this.morphiaConfig.getAuthDatabase(), (char[])this.morphiaConfig.getPassword().toCharArray());
            mongoClient = new MongoClient(new ServerAddress(this.morphiaConfig.getHost(), this.morphiaConfig.getPort().intValue()), credential, options);
        } else {
            mongoClient = new MongoClient(new ServerAddress(this.morphiaConfig.getHost(), this.morphiaConfig.getPort().intValue()));
        }
        Datastore datastore = morphia.createDatastore(mongoClient, this.morphiaConfig.getDatabase());
        datastore.ensureIndexes();
        return datastore;
    }
}

