/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress;

import java.lang.reflect.Constructor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.openjdk.jcstress.infra.Status;
import org.openjdk.jcstress.infra.collectors.TestResult;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;
import org.openjdk.jcstress.infra.runners.Runner;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.util.StringUtils;

public class EmbeddedExecutor {
    private final ExecutorService pool;
    private final TestResultCollector sink;
    private Consumer<TestConfig> onFinish;

    public EmbeddedExecutor(TestResultCollector sink) {
        this(sink, null);
    }

    public EmbeddedExecutor(TestResultCollector sink, Consumer<TestConfig> onFinish) {
        this.sink = sink;
        this.onFinish = onFinish;
        this.pool = Executors.newCachedThreadPool(new ThreadFactory(){
            private final AtomicInteger id = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("jcstress-worker-" + this.id.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
    }

    public void submit(TestConfig config) {
        this.pool.submit(this.task(config));
    }

    public void run(TestConfig config) {
        this.task(config).run();
    }

    private Runnable task(TestConfig config) {
        return () -> {
            try {
                Class<?> aClass = Class.forName(config.generatedRunnerName);
                Constructor<?> cnstr = aClass.getConstructor(TestConfig.class, TestResultCollector.class, ExecutorService.class);
                Runner o = (Runner)cnstr.newInstance(config, this.sink, this.pool);
                o.run();
            }
            catch (ClassFormatError | NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError e) {
                TestResult result = new TestResult(config, Status.API_MISMATCH, 0);
                result.addAuxData(StringUtils.getStacktrace(e));
                this.sink.add(result);
            }
            catch (Throwable ex) {
                TestResult result = new TestResult(config, Status.TEST_ERROR, 0);
                result.addAuxData(StringUtils.getStacktrace(ex));
                this.sink.add(result);
            }
            finally {
                if (this.onFinish != null) {
                    this.onFinish.accept(config);
                }
            }
        };
    }
}

