/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.openjdk.jcstress.Options;
import org.openjdk.jcstress.TestExecutor;
import org.openjdk.jcstress.infra.TestInfo;
import org.openjdk.jcstress.infra.collectors.DiskReadCollector;
import org.openjdk.jcstress.infra.collectors.DiskWriteCollector;
import org.openjdk.jcstress.infra.collectors.InProcessCollector;
import org.openjdk.jcstress.infra.collectors.MuxCollector;
import org.openjdk.jcstress.infra.collectors.SerializedBufferCollector;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;
import org.openjdk.jcstress.infra.grading.ConsoleReportPrinter;
import org.openjdk.jcstress.infra.grading.ExceptionReportPrinter;
import org.openjdk.jcstress.infra.grading.HTMLReportPrinter;
import org.openjdk.jcstress.infra.grading.TextReportPrinter;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.infra.runners.TestList;
import org.openjdk.jcstress.vm.VMSupport;

public class JCStress {
    final PrintStream out;
    final Options opts;

    public JCStress(Options opts) {
        this.opts = opts;
        this.out = System.out;
    }

    public void run() throws Exception {
        VMSupport.detectAvailableVMModes(this.opts.getJvmArgs(), this.opts.getJvmArgsPrepend());
        if (VMSupport.getAvailableVMModes().isEmpty()) {
            this.out.println("FATAL: No JVM modes to run with.");
            return;
        }
        VMSupport.initFlags(this.opts);
        this.opts.printSettingsOn(this.out);
        SortedSet<String> tests = this.getTests();
        List<TestConfig> configs = this.prepareRunProgram(tests);
        ConsoleReportPrinter printer = new ConsoleReportPrinter(this.opts, new PrintWriter(this.out, true), tests.size(), configs.size());
        DiskWriteCollector diskCollector = new DiskWriteCollector(this.opts.getResultFile());
        TestResultCollector mux = MuxCollector.of(printer, diskCollector);
        SerializedBufferCollector sink = new SerializedBufferCollector(mux);
        TestExecutor executor = new TestExecutor(this.opts.getUserCPUs(), this.opts.getBatchSize(), sink, true);
        executor.runAll(configs);
        sink.close();
        diskCollector.close();
        this.out.println();
        this.out.println();
        this.out.println("RUN COMPLETE.");
        this.out.println();
        this.parseResults();
    }

    public void parseResults() throws Exception {
        InProcessCollector collector = new InProcessCollector();
        new DiskReadCollector(this.opts.getResultFile(), collector).dump();
        new TextReportPrinter(this.opts, collector).work();
        new HTMLReportPrinter(this.opts, collector).work();
        this.out.println();
        this.out.println("HTML report was generated. Look at " + this.opts.getResultDest() + "index.html for the complete run results.");
        this.out.println();
        this.out.println("Will throw any pending exceptions at this point.");
        new ExceptionReportPrinter(collector).work();
        this.out.println("Done.");
    }

    private List<TestConfig> prepareRunProgram(Set<String> tests) {
        ArrayList<TestConfig> configs = new ArrayList<TestConfig>();
        if (this.opts.shouldFork()) {
            List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String test : tests) {
                for (Collection<String> jvmArgs : VMSupport.getAvailableVMModes()) {
                    ArrayList<String> fullArgs = new ArrayList<String>();
                    fullArgs.addAll(inputArgs);
                    fullArgs.addAll(jvmArgs);
                    for (int f = 0; f < this.opts.getForks(); ++f) {
                        configs.add(new TestConfig(this.opts, TestList.getInfo(test), TestConfig.RunMode.FORKED, f, fullArgs));
                    }
                }
            }
        } else {
            for (String test : tests) {
                TestInfo info = TestList.getInfo(test);
                TestConfig.RunMode mode = info.requiresFork() ? TestConfig.RunMode.FORKED : TestConfig.RunMode.EMBEDDED;
                configs.add(new TestConfig(this.opts, info, mode, -1, Collections.emptyList()));
            }
        }
        Collections.shuffle(configs);
        return configs;
    }

    public SortedSet<String> getTests() {
        String filter = this.opts.getTestFilter();
        TreeSet<String> s = new TreeSet<String>();
        Pattern pattern = Pattern.compile(filter);
        for (String testName : TestList.tests()) {
            if (!pattern.matcher(testName).find()) continue;
            s.add(testName);
        }
        return s;
    }
}

