/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.openjdk.jcstress.JCStress;
import org.openjdk.jcstress.Options;

public class Main {
    public static void main(String[] args) throws Exception {
        System.out.println("Java Concurrency Stress Tests");
        System.out.println("---------------------------------------------------------------------------------");
        Main.printVersion(System.out);
        System.out.println();
        Options opts = new Options(args);
        if (!opts.parse()) {
            System.exit(1);
        }
        JCStress jcstress = new JCStress(opts);
        if (opts.shouldList()) {
            for (String test : jcstress.getTests()) {
                System.out.println(test);
            }
        } else if (opts.shouldParse()) {
            jcstress.parseResults();
        } else {
            jcstress.run();
        }
    }

    static void printVersion(PrintStream out) {
        Class<Main> clazz = Main.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        InputStream stream = null;
        try {
            stream = new URL(manifestPath).openStream();
            Manifest manifest = new Manifest(stream);
            Attributes attr = manifest.getMainAttributes();
            out.printf("Rev: %s, built by %s with %s at %s%n", attr.getValue("Implementation-Build"), attr.getValue("Built-By"), attr.getValue("Build-Jdk"), attr.getValue("Build-Time"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

