/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.openjdk.jcstress.infra.runners.SpinLoopStyle;
import org.openjdk.jcstress.util.OptionFormatter;
import org.openjdk.jcstress.util.Promise;
import org.openjdk.jcstress.util.StringUtils;
import org.openjdk.jcstress.vm.VMSupport;

public class Options {
    private String resultDir;
    private String testFilter;
    private int minStride;
    private int maxStride;
    private int maxFootprint;
    private int time;
    private int iters;
    private final String[] args;
    private boolean parse;
    private boolean list;
    private boolean verbose;
    private Promise<Integer> systemCPUs;
    private Promise<Integer> userCPUs;
    private int forks;
    private String mode;
    private boolean userYield;
    private String resultFile;
    private int deoptRatio;
    private Collection<String> jvmArgs;
    private Collection<String> jvmArgsPrepend;
    private int batchSize;

    public Options(String[] args) {
        this.args = args;
    }

    public boolean parse() throws IOException {
        OptionSet set;
        OptionParser parser = new OptionParser();
        parser.formatHelpWith((HelpFormatter)new OptionFormatter());
        ArgumentAcceptingOptionSpec result = parser.accepts("r", "Target destination to put the report into.").withRequiredArg().ofType(String.class).describedAs("dir");
        ArgumentAcceptingOptionSpec parse = parser.accepts("p", "Re-run parser on the result file. This will not run any tests.").withRequiredArg().ofType(String.class).describedAs("result file");
        ArgumentAcceptingOptionSpec list = parser.accepts("l", "List the available tests matching the requested settings.").withOptionalArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec testFilter = parser.accepts("t", "Regexp selector for tests.").withRequiredArg().ofType(String.class).describedAs("regexp");
        ArgumentAcceptingOptionSpec minStride = parser.accepts("minStride", "Minimum internal stride size. Larger value decreases the synchronization overhead, but also reduces accuracy.").withRequiredArg().ofType(Integer.class).describedAs("N");
        ArgumentAcceptingOptionSpec maxStride = parser.accepts("maxStride", "Maximum internal stride size. Larger value decreases the synchronization overhead, but also reduces accuracy.").withRequiredArg().ofType(Integer.class).describedAs("N");
        ArgumentAcceptingOptionSpec time = parser.accepts("time", "Time to spend in single test iteration. Larger value improves test reliability, since schedulers do better job in the long run.").withRequiredArg().ofType(Integer.class).describedAs("ms");
        ArgumentAcceptingOptionSpec iters = parser.accepts("iters", "Iterations per test.").withRequiredArg().ofType(Integer.class).describedAs("N");
        ArgumentAcceptingOptionSpec cpus = parser.accepts("c", "Concurrency level for tests. This value can be greater than number of CPUs available.").withRequiredArg().ofType(Integer.class).describedAs("N");
        ArgumentAcceptingOptionSpec sysCpus = parser.accepts("sc", "Number of CPUs in the system. Setting this value overrides the autodetection.").withRequiredArg().ofType(Integer.class).describedAs("N");
        ArgumentAcceptingOptionSpec maxFootprint = parser.accepts("mf", "Maximum footprint for each test, in megabytes. This affects the stride size: maximum footprint will never be exceeded, regardless of min/max stride sizes.").withRequiredArg().ofType(Integer.class).describedAs("MB");
        ArgumentAcceptingOptionSpec batchSize = parser.accepts("bs", "Maximum number of tests to execute in a single VM. Larger values will improve test performance, at expense of testing accuracy").withRequiredArg().ofType(Integer.class).describedAs("#");
        ArgumentAcceptingOptionSpec shouldYield = parser.accepts("yield", "Call Thread.yield() in busy loops.").withOptionalArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec forks = parser.accepts("f", "Should fork each test N times. \"0\" to run in the embedded mode with occasional forking.").withOptionalArg().ofType(Integer.class).describedAs("count");
        ArgumentAcceptingOptionSpec modeStr = parser.accepts("m", "Test mode preset: sanity, quick, default, tough, stress.").withRequiredArg().ofType(String.class).describedAs("mode");
        ArgumentAcceptingOptionSpec deoptRatio = parser.accepts("deoptRatio", "De-optimize (roughly) every N-th iteration. Larger value improves test performance, but decreases the chance we hit unlucky compilation.").withRequiredArg().ofType(Integer.class).describedAs("N");
        ArgumentAcceptingOptionSpec optJvmArgs = parser.accepts("jvmArgs", "Use given JVM arguments. This disables JVM flags auto-detection, and runs only the single JVM mode. Either a single space-separated option line, or multiple options are accepted. This option only affects forked runs.").withRequiredArg().ofType(String.class).describedAs("string");
        ArgumentAcceptingOptionSpec optJvmArgsPrepend = parser.accepts("jvmArgsPrepend", "Prepend given JVM arguments to auto-detected configurations. Either a single space-separated option line, or multiple options are accepted. This option only affects forked runs.").withRequiredArg().ofType(String.class).describedAs("string");
        parser.accepts("v", "Be extra verbose.");
        parser.accepts("h", "Print this help.");
        try {
            set = parser.parse(this.args);
        }
        catch (OptionException e) {
            System.err.println("ERROR: " + e.getMessage());
            System.err.println();
            parser.printHelpOn((OutputStream)System.err);
            return false;
        }
        if (set.has("h")) {
            parser.printHelpOn((OutputStream)System.out);
            return false;
        }
        this.resultDir = this.orDefault((String)set.valueOf((OptionSpec)result), "results/");
        if (!this.resultDir.endsWith("/")) {
            this.resultDir = this.resultDir + "/";
        }
        this.minStride = this.orDefault((Integer)set.valueOf((OptionSpec)minStride), 10);
        this.maxStride = this.orDefault((Integer)set.valueOf((OptionSpec)maxStride), 10000);
        this.maxFootprint = this.orDefault((Integer)set.valueOf((OptionSpec)maxFootprint), 100);
        this.testFilter = this.orDefault((String)set.valueOf((OptionSpec)testFilter), ".*");
        this.parse = this.orDefault(set.has((OptionSpec)parse), false);
        if (this.parse) {
            this.resultFile = (String)set.valueOf((OptionSpec)parse);
        } else {
            String timestamp = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.ROOT).format(new Date());
            this.resultFile = "jcstress-results-" + timestamp + ".bin.gz";
        }
        this.list = this.orDefault(set.has((OptionSpec)list), false);
        this.verbose = this.orDefault(set.has("v"), false);
        this.systemCPUs = !set.hasArgument((OptionSpec)sysCpus) ? Promise.of(VMSupport::figureOutHotCPUs) : Promise.of((Integer)set.valueOf((OptionSpec)sysCpus));
        this.userCPUs = !set.hasArgument((OptionSpec)cpus) ? this.systemCPUs : Promise.of((Integer)set.valueOf((OptionSpec)cpus));
        this.userYield = set.has((OptionSpec)shouldYield);
        this.mode = this.orDefault((String)modeStr.value(set), "default");
        if (this.mode.equalsIgnoreCase("sanity")) {
            this.time = 10;
            this.iters = 1;
            this.forks = 1;
            this.batchSize = 100;
        } else if (this.mode.equalsIgnoreCase("quick")) {
            this.time = 200;
            this.iters = 5;
            this.forks = 1;
            this.batchSize = 20;
        } else if (this.mode.equalsIgnoreCase("default")) {
            this.time = 1000;
            this.iters = 5;
            this.forks = 1;
            this.batchSize = 5;
        } else if (this.mode.equalsIgnoreCase("tough")) {
            this.time = 1000;
            this.iters = 10;
            this.forks = 10;
            this.batchSize = 5;
        } else if (this.mode.equalsIgnoreCase("stress")) {
            this.time = 1000;
            this.iters = 50;
            this.forks = 10;
            this.batchSize = 1;
        } else {
            System.err.println("Unknown test mode: " + this.mode);
            System.err.println();
            parser.printHelpOn((OutputStream)System.err);
            return false;
        }
        this.time = this.orDefault((Integer)set.valueOf((OptionSpec)time), this.time);
        this.iters = this.orDefault((Integer)set.valueOf((OptionSpec)iters), this.iters);
        this.forks = this.orDefault((Integer)set.valueOf((OptionSpec)forks), this.forks);
        this.batchSize = this.orDefault((Integer)set.valueOf((OptionSpec)batchSize), this.batchSize);
        this.deoptRatio = this.orDefault((Integer)set.valueOf((OptionSpec)deoptRatio), this.iters * 3);
        this.jvmArgs = this.processArgs((OptionSpec<String>)optJvmArgs, set);
        this.jvmArgsPrepend = this.processArgs((OptionSpec<String>)optJvmArgsPrepend, set);
        return true;
    }

    private Collection<String> processArgs(OptionSpec<String> op, OptionSet set) {
        if (set.hasArgument(op)) {
            try {
                List vals = op.values(set);
                if (vals.size() != 1) {
                    return vals;
                }
                return StringUtils.splitQuotedEscape((String)op.value(set));
            }
            catch (OptionException e) {
                return StringUtils.splitQuotedEscape((String)op.value(set));
            }
        }
        return null;
    }

    private <T> T orDefault(T t, T def) {
        return t != null ? t : def;
    }

    public int getForks() {
        return this.forks;
    }

    public void printSettingsOn(PrintStream out) {
        out.printf("  Hardware threads in use/available: %d/%d, %s%n", new Object[]{this.getUserCPUs(), this.getSystemCPUs(), this.getSpinStyle()});
        out.printf("  Test preset mode: \"%s\"%n", this.mode);
        out.printf("  Writing the test results to \"%s\"%n", this.resultFile);
        out.printf("  Parsing results to \"%s\"%n", this.resultDir);
        out.printf("  Running each test matching \"%s\" for %d forks, %d iterations, %d ms each%n", this.getTestFilter(), this.getForks(), this.getIterations(), this.getTime());
        out.printf("  Each JVM would execute at most %d tests in the row.%n", this.getBatchSize());
        out.printf("  Solo stride size will be autobalanced within [%d, %d] elements, but taking no more than %d Mb.%n", this.getMinStride(), this.getMaxStride(), this.getMaxFootprintMb());
        out.println();
    }

    public int deoptRatio() {
        return this.deoptRatio;
    }

    public int getMinStride() {
        return this.minStride;
    }

    public int getMaxStride() {
        return this.maxStride;
    }

    public String getResultDest() {
        return this.resultDir;
    }

    public int getTime() {
        return this.time;
    }

    public SpinLoopStyle getSpinStyle() {
        if (VMSupport.spinWaitHintAvailable()) {
            return SpinLoopStyle.THREAD_SPIN_WAIT;
        }
        if (this.userYield) {
            return SpinLoopStyle.THREAD_YIELD;
        }
        return SpinLoopStyle.PLAIN;
    }

    public boolean shouldParse() {
        return this.parse;
    }

    public boolean shouldList() {
        return this.list;
    }

    public String getTestFilter() {
        return this.testFilter;
    }

    public boolean shouldFork() {
        return this.forks > 0;
    }

    public int getIterations() {
        return this.iters;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public int getUserCPUs() {
        return this.userCPUs.get();
    }

    public int getSystemCPUs() {
        return this.systemCPUs.get();
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public Collection<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public Collection<String> getJvmArgsPrepend() {
        return this.jvmArgsPrepend;
    }

    public int getMaxFootprintMb() {
        return this.maxFootprint;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

