/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.openjdk.jcstress.EmbeddedExecutor;
import org.openjdk.jcstress.ForkFailedException;
import org.openjdk.jcstress.ForkedMain;
import org.openjdk.jcstress.infra.Status;
import org.openjdk.jcstress.infra.collectors.TestResult;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.link.BinaryLinkServer;
import org.openjdk.jcstress.link.ServerListener;
import org.openjdk.jcstress.util.HashMultimap;
import org.openjdk.jcstress.util.Multimap;
import org.openjdk.jcstress.vm.VMSupport;

public class TestExecutor {
    private static final int SPIN_WAIT_DELAY_MS = 100;
    static final AtomicInteger ID = new AtomicInteger();
    private final Semaphore semaphore;
    private final BinaryLinkServer server;
    private final int maxThreads;
    private final int batchSize;
    private final TestResultCollector sink;
    private final Multimap<BatchKey, TestConfig> tasks;
    private final EmbeddedExecutor embeddedExecutor;
    private final Map<String, VM> vmByToken;

    public TestExecutor(int maxThreads, int batchSize, final TestResultCollector sink, boolean possiblyForked) throws IOException {
        this.maxThreads = maxThreads;
        this.batchSize = batchSize;
        this.sink = sink;
        this.tasks = new HashMultimap<BatchKey, TestConfig>();
        this.vmByToken = new ConcurrentHashMap<String, VM>();
        this.semaphore = new Semaphore(maxThreads);
        this.server = possiblyForked ? new BinaryLinkServer(new ServerListener(){

            @Override
            public TestConfig onJobRequest(String token) {
                return ((VM)TestExecutor.this.vmByToken.get(token)).jobRequest();
            }

            @Override
            public void onResult(String token, TestResult result) {
                ((VM)TestExecutor.this.vmByToken.get(token)).processResult(result);
                sink.add(result);
            }
        }) : null;
        this.embeddedExecutor = new EmbeddedExecutor(sink, cfg -> this.release(cfg.threads));
    }

    public void runAll(List<TestConfig> configs) throws InterruptedException {
        block4: for (TestConfig cfg : configs) {
            switch (cfg.runMode) {
                case EMBEDDED: {
                    this.waitForMoreThreads(cfg.threads);
                    this.embeddedExecutor.submit(cfg);
                    continue block4;
                }
                case FORKED: {
                    BatchKey batchKey = BatchKey.getFrom(cfg);
                    this.tasks.put(batchKey, cfg);
                    Collection<TestConfig> curBatch = this.tasks.get(batchKey);
                    if (curBatch.size() < this.batchSize) continue block4;
                    this.tasks.remove(batchKey);
                    this.doSchedule(batchKey, curBatch);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unknown mode: " + (Object)((Object)cfg.runMode));
        }
        for (BatchKey key : this.tasks.keys()) {
            Collection<TestConfig> curBatch = this.tasks.get(key);
            if (curBatch.isEmpty()) continue;
            this.doSchedule(key, curBatch);
        }
        this.waitForMoreThreads(this.maxThreads);
        this.server.terminate();
    }

    private void doSchedule(BatchKey batchKey, Collection<TestConfig> configs) {
        this.waitForMoreThreads(batchKey.threads);
        String token = "fork-token-" + ID.incrementAndGet();
        VM vm = new VM(this.server.getHost(), this.server.getPort(), batchKey, token, configs);
        this.vmByToken.put(token, vm);
        vm.start();
    }

    private void waitForMoreThreads(int threads) {
        while (!this.tryAcquire(threads)) {
            this.processReadyVMs();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean tryAcquire(int requested) {
        int threads = Math.min(requested, this.maxThreads);
        return this.semaphore.tryAcquire(threads);
    }

    private void release(int requested) {
        int threads = Math.min(requested, this.maxThreads);
        this.semaphore.release(threads);
    }

    private void processReadyVMs() {
        for (VM vm : this.vmByToken.values()) {
            try {
                if (!vm.checkTermination()) {
                    continue;
                }
            }
            catch (ForkFailedException e) {
                TestConfig failed = vm.getVictimTask();
                TestResult result = new TestResult(failed, Status.VM_ERROR, -1);
                for (String i : e.getInfo()) {
                    result.addAuxData(i);
                }
                this.sink.add(result);
            }
            this.vmByToken.remove(vm.token, vm);
            this.release(vm.key.threads);
            List<TestConfig> pending = vm.getPendingTasks();
            if (pending.isEmpty()) continue;
            this.doSchedule(vm.key, pending);
        }
    }

    static class BatchKey {
        private int threads;
        private List<String> jvmArgs;

        BatchKey(int threads, List<String> jvmArgs) {
            this.threads = threads;
            this.jvmArgs = jvmArgs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BatchKey batchKey = (BatchKey)o;
            if (this.threads != batchKey.threads) {
                return false;
            }
            return this.jvmArgs.equals(batchKey.jvmArgs);
        }

        public int hashCode() {
            int result = this.threads;
            result = 31 * result + this.jvmArgs.hashCode();
            return result;
        }

        static BatchKey getFrom(TestConfig cfg) {
            return new BatchKey(cfg.threads, cfg.jvmArgs);
        }
    }

    private static class VM {
        private final String host;
        private final int port;
        private final BatchKey key;
        private final String token;
        private final File stdout;
        private final File stderr;
        private final TestConfig firstTask;
        private Process process;
        private final List<TestConfig> pendingTasks;
        private TestConfig currentTask;
        private TestConfig lastTask;
        private IOException pendingException;

        public VM(String host, int port, BatchKey key, String token, Collection<TestConfig> configs) {
            this.host = host;
            this.port = port;
            this.key = key;
            this.token = token;
            this.pendingTasks = new ArrayList<TestConfig>(configs);
            this.firstTask = this.pendingTasks.get(0);
            try {
                this.stdout = File.createTempFile("jcstress", "stdout");
                this.stderr = File.createTempFile("jcstress", "stderr");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        void start() {
            try {
                ArrayList<String> command = new ArrayList<String>();
                command.addAll(VMSupport.getJavaInvokeLine());
                command.addAll(this.key.jvmArgs);
                command.add(ForkedMain.class.getName());
                command.add(this.host);
                command.add(String.valueOf(this.port));
                command.add(this.token);
                ProcessBuilder pb = new ProcessBuilder(command);
                pb.redirectOutput(this.stdout);
                pb.redirectError(this.stderr);
                this.process = pb.start();
            }
            catch (IOException ex) {
                this.pendingException = ex;
            }
        }

        boolean checkTermination() {
            block10: {
                if (this.pendingException != null) {
                    throw new ForkFailedException(this.pendingException.getMessage());
                }
                if (this.process.isAlive()) {
                    return false;
                }
                try {
                    int ecode = this.process.waitFor();
                    if (ecode == 0) break block10;
                    ArrayList<String> output = new ArrayList<String>();
                    try {
                        output.addAll(Files.readAllLines(this.stdout.toPath()));
                    }
                    catch (IOException e) {
                        output.add("Failed to read stdout: " + e.getMessage());
                    }
                    try {
                        output.addAll(Files.readAllLines(this.stderr.toPath()));
                    }
                    catch (IOException e) {
                        output.add("Failed to read stderr: " + e.getMessage());
                    }
                    if (this.stdout.delete()) {
                        output.add("Failed to delete stdout log: " + this.stdout);
                    }
                    if (this.stderr.delete()) {
                        output.add("Failed to delete stderr log: " + this.stderr);
                    }
                    throw new ForkFailedException(output);
                }
                catch (InterruptedException ex) {
                    throw new ForkFailedException(ex.getMessage());
                }
            }
            return true;
        }

        public synchronized TestConfig jobRequest() {
            TestConfig task;
            if (this.pendingTasks.isEmpty()) {
                return null;
            }
            this.currentTask = task = this.pendingTasks.remove(0);
            return task;
        }

        public synchronized void processResult(TestResult result) {
            this.lastTask = this.currentTask;
            this.currentTask = null;
        }

        public synchronized TestConfig getVictimTask() {
            if (this.currentTask != null) {
                return this.currentTask;
            }
            if (this.lastTask != null) {
                return this.lastTask;
            }
            return this.firstTask;
        }

        public List<TestConfig> getPendingTasks() {
            return new ArrayList<TestConfig>(this.pendingTasks);
        }
    }
}

