/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.openjdk.jcstress.annotations.Expect;
import org.openjdk.jcstress.infra.StateCase;

public class TestInfo {
    private final String name;
    private final String description;
    private final String runner;
    private final int threads;
    private final boolean requiresFork;
    private final Collection<StateCase> stateCases;
    private StateCase unmatched;
    private final Collection<String> refs;

    public TestInfo(String name, String runner, String description, int threads, boolean requiresFork) {
        this.name = name;
        this.runner = runner;
        this.description = description;
        this.threads = threads;
        this.requiresFork = requiresFork;
        this.stateCases = new ArrayList<StateCase>();
        this.refs = new ArrayList<String>();
    }

    public StateCase unmatched() {
        if (this.unmatched != null) {
            return this.unmatched;
        }
        return new StateCase(Pattern.compile(".*"), Expect.FORBIDDEN, "No default case provided, assume " + (Object)((Object)Expect.FORBIDDEN));
    }

    public Collection<StateCase> cases() {
        return this.stateCases;
    }

    public void addCase(StateCase aStateCase) {
        if (aStateCase.matchPattern().isEmpty()) {
            this.unmatched = aStateCase;
        } else {
            this.stateCases.add(aStateCase);
        }
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String generatedRunner() {
        return this.runner;
    }

    public int threads() {
        return this.threads;
    }

    public boolean requiresFork() {
        return this.requiresFork;
    }

    public void addRef(String ref) {
        this.refs.add(ref);
    }

    public Collection<String> refs() {
        return this.refs;
    }
}

