/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.collectors;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;
import org.openjdk.jcstress.infra.collectors.TestResult;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;

public class DiskReadCollector {
    private final ObjectInputStream ois;
    private final TestResultCollector collector;
    private final FileInputStream fis;
    private final GZIPInputStream gis;

    public DiskReadCollector(String fileName, TestResultCollector collector) throws IOException {
        this.collector = collector;
        File file = new File(fileName);
        this.fis = new FileInputStream(file);
        this.gis = new GZIPInputStream(this.fis);
        this.ois = new ObjectInputStream(this.gis);
    }

    public void dump() throws IOException, ClassNotFoundException {
        try {
            Object o;
            while ((o = this.ois.readObject()) != null) {
                if (!(o instanceof TestResult)) continue;
                this.collector.add((TestResult)o);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.ois.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.gis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.fis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

