/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.collectors;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.openjdk.jcstress.infra.collectors.TestResult;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;
import org.openjdk.jcstress.util.Environment;

public class DiskWriteCollector
implements TestResultCollector {
    private final FileOutputStream fos;
    private final GZIPOutputStream gos;
    private final ObjectOutputStream oos;
    private int frames;

    public DiskWriteCollector(String fileName) throws IOException {
        File file = new File(fileName);
        this.fos = new FileOutputStream(file);
        this.gos = new GZIPOutputStream(this.fos);
        this.oos = new ObjectOutputStream(this.gos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(TestResult result) {
        DiskWriteCollector diskWriteCollector = this;
        synchronized (diskWriteCollector) {
            try {
                if ((this.frames++ & 0xFFF) == 0) {
                    this.oos.reset();
                }
                result.setEnv(Environment.getInstance());
                this.oos.writeObject(result);
                this.oos.flush();
                this.gos.flush();
                this.fos.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DiskWriteCollector diskWriteCollector = this;
        synchronized (diskWriteCollector) {
            DiskWriteCollector.flushAndClose(this.oos);
            DiskWriteCollector.flushAndClose(this.gos);
            DiskWriteCollector.flushAndClose(this.fos);
        }
    }

    private static void flushAndClose(OutputStream stream) {
        try {
            stream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

