/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.collectors;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.openjdk.jcstress.infra.collectors.TestResult;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;

public class SerializedBufferCollector
implements TestResultCollector {
    private final TestResultCollector sink;
    private final BlockingQueue<TestResult> results;
    private final Thread processor;
    private volatile boolean terminated;

    public SerializedBufferCollector(TestResultCollector dst) {
        this.sink = dst;
        this.results = new LinkedBlockingQueue<TestResult>();
        this.processor = new Thread(this::work);
        this.processor.setName(SerializedBufferCollector.class.getName() + " processor thread");
        this.processor.setDaemon(true);
        this.processor.start();
    }

    public void close() {
        this.terminated = true;
        try {
            this.processor.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void work() {
        try {
            while (true) {
                TestResult r;
                if ((r = this.results.poll(1L, TimeUnit.SECONDS)) != null) {
                    this.sink.add(r);
                    continue;
                }
                if (this.terminated) break;
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public void add(TestResult result) {
        this.results.add(result);
    }
}

