/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.collectors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openjdk.jcstress.infra.Status;
import org.openjdk.jcstress.infra.grading.TestGrading;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.util.Environment;
import org.openjdk.jcstress.util.HashMultiset;
import org.openjdk.jcstress.util.Multiset;

public class TestResult
implements Serializable {
    private final TestConfig config;
    private final Status status;
    private final int iterationId;
    private final Multiset<String> states;
    private volatile Environment env;
    private final List<String> auxData;

    public TestResult(TestConfig config, Status status, int iterationId) {
        this.config = config;
        this.status = status;
        this.iterationId = iterationId;
        this.states = new HashMultiset<String>();
        this.auxData = new ArrayList<String>();
    }

    public int getIteration() {
        return this.iterationId;
    }

    public void addState(String result, long count) {
        this.states.add(result, count);
    }

    public void addAuxData(String data) {
        this.auxData.add(data);
    }

    public void setEnv(Environment e) {
        this.env = e;
    }

    public String getName() {
        return this.config.name;
    }

    public Environment getEnv() {
        return this.env;
    }

    public Status status() {
        return this.status;
    }

    public List<String> getAuxData() {
        return this.auxData;
    }

    public long getTotalCount() {
        return this.states.size();
    }

    public long getCount(String s) {
        return this.states.count(s);
    }

    public Collection<String> getStateKeys() {
        return this.states.keys();
    }

    public TestConfig getConfig() {
        return this.config;
    }

    public TestGrading grading() {
        return TestGrading.grade(this);
    }
}

