/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.grading;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openjdk.jcstress.Options;
import org.openjdk.jcstress.infra.collectors.TestResult;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;
import org.openjdk.jcstress.infra.grading.ReportUtils;
import org.openjdk.jcstress.infra.grading.TestGrading;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.util.StringUtils;

public class ConsoleReportPrinter
implements TestResultCollector {
    private final boolean verbose;
    private final PrintWriter output;
    private final long expectedTests;
    private final long expectedIterations;
    private final long expectedForks;
    private long observedIterations;
    private long observedCount;
    private final Set<String> observedTests = Collections.newSetFromMap(new HashMap());
    private final Set<ConfigFork> observedForks = Collections.newSetFromMap(new HashMap());
    private long firstTest;
    private int progressLen;
    private long passed;
    private long failed;
    private long softErrors;
    private long hardErrors;

    public ConsoleReportPrinter(Options opts, PrintWriter pw, int expectedTests, int expectedForks) throws FileNotFoundException {
        this.output = pw;
        this.expectedTests = expectedTests;
        this.expectedForks = expectedForks;
        this.expectedIterations = expectedForks * (opts.getIterations() + 1);
        this.verbose = opts.isVerbose();
        this.progressLen = 1;
    }

    @Override
    public synchronized void add(TestResult r) {
        if (this.firstTest == 0L) {
            this.firstTest = System.nanoTime();
        }
        this.observedTests.add(r.getName());
        this.observedForks.add(new ConfigFork(r.getConfig()));
        ++this.observedIterations;
        this.observedCount += r.getTotalCount();
        this.printResult(r);
    }

    private void printResult(TestResult r) {
        TestGrading grading = r.grading();
        switch (r.status()) {
            case TIMEOUT_ERROR: 
            case CHECK_TEST_ERROR: 
            case TEST_ERROR: 
            case VM_ERROR: {
                ++this.hardErrors;
                break;
            }
            case API_MISMATCH: {
                ++this.softErrors;
                break;
            }
            case NORMAL: {
                if (grading.isPassed) {
                    ++this.passed;
                    break;
                }
                ++this.failed;
                break;
            }
            default: {
                throw new IllegalStateException("Illegal status: " + (Object)((Object)r.status()));
            }
        }
        this.printLine(r);
        if (!grading.isPassed || grading.hasInteresting || this.verbose) {
            ReportUtils.printDetails(this.output, r, true);
        }
        ReportUtils.printMessages(this.output, r);
        this.printProgress();
    }

    private void printLine(TestResult r) {
        String label = ReportUtils.statusToLabel(r);
        this.output.printf("\r%" + this.progressLen + "s\r", "");
        this.output.printf("%10s %s%n", "[" + label + "]", StringUtils.chunkName(r.getName()));
    }

    private void printProgress() {
        String line = String.format("(ETA: %10s) (Rate: %s samples/sec) (Tests: %d of %d) (Forks: %2d of %d) (Iterations: %2d of %d; %d passed, %d failed, %d soft errs, %d hard errs) ", this.computeETA(), this.computeSpeed(), this.observedTests.size(), this.expectedTests, this.observedForks.size(), this.expectedForks, this.observedIterations, this.expectedIterations, this.passed, this.failed, this.softErrors, this.hardErrors);
        this.progressLen = line.length();
        this.output.print(line);
        this.output.flush();
    }

    private String computeSpeed() {
        long timeSpent = System.nanoTime() - this.firstTest;
        return String.format("%3.2E", 1.0 * (double)TimeUnit.SECONDS.toNanos(1L) * (double)this.observedCount / (double)timeSpent);
    }

    private String computeETA() {
        long timeSpent = System.nanoTime() - this.firstTest;
        long resultsGot = this.observedIterations;
        if (resultsGot == 0L) {
            return "n/a";
        }
        long nsToGo = (long)((double)timeSpent * (1.0 * (double)(this.expectedIterations - 1L) / (double)resultsGot - 1.0));
        if (nsToGo > 0L) {
            String result = "";
            long days = TimeUnit.NANOSECONDS.toDays(nsToGo);
            if (days > 0L) {
                result = result + days + "d+";
                nsToGo -= TimeUnit.DAYS.toNanos(days);
            }
            long hours = TimeUnit.NANOSECONDS.toHours(nsToGo);
            long minutes = TimeUnit.NANOSECONDS.toMinutes(nsToGo -= TimeUnit.HOURS.toNanos(hours));
            long seconds = TimeUnit.NANOSECONDS.toSeconds(nsToGo -= TimeUnit.MINUTES.toNanos(minutes));
            result = result + String.format("%02d:%02d:%02d", hours, minutes, seconds);
            return result;
        }
        return "now";
    }

    static class ConfigFork {
        private TestConfig config;

        public ConfigFork(TestConfig config) {
            this.config = config;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigFork that = (ConfigFork)o;
            if (this.config.forkId != that.config.forkId) {
                return false;
            }
            return this.config.equals(that.config);
        }

        public int hashCode() {
            int result = this.config.hashCode();
            result = 31 * result + this.config.forkId;
            return result;
        }
    }
}

