/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.grading;

import java.util.ArrayList;
import java.util.List;
import org.openjdk.jcstress.infra.collectors.InProcessCollector;
import org.openjdk.jcstress.infra.collectors.TestResult;
import org.openjdk.jcstress.infra.grading.ReportUtils;
import org.openjdk.jcstress.infra.grading.TestGrading;

public class ExceptionReportPrinter {
    private final List<String> failures;
    private final InProcessCollector collector;

    public ExceptionReportPrinter(InProcessCollector collector) {
        this.collector = collector;
        this.failures = new ArrayList<String>();
    }

    public void work() {
        List<TestResult> results = ReportUtils.mergedByConfig(this.collector.getTestResults());
        for (TestResult k : results) {
            this.emitTest(k);
        }
        if (!this.failures.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(System.lineSeparator());
            for (String f : this.failures) {
                sb.append(f).append(System.lineSeparator());
            }
            throw new AssertionError((Object)("TEST FAILURES: " + sb.toString()));
        }
    }

    public void emitTest(TestResult result) {
        String label = result.getName() + " " + result.getConfig().jvmArgs;
        switch (result.status()) {
            case CHECK_TEST_ERROR: {
                this.failures.add(label + " had failed with the pre-test error.");
                break;
            }
            case TEST_ERROR: {
                this.failures.add(label + " had failed with the test error.");
                break;
            }
            case TIMEOUT_ERROR: {
                this.failures.add(label + " had timed out.");
                break;
            }
            case VM_ERROR: {
                this.failures.add(label + " had failed with the VM error.");
                break;
            }
            case NORMAL: {
                TestGrading grading = result.grading();
                if (grading.failureMessages.isEmpty()) break;
                for (String msg : grading.failureMessages) {
                    this.failures.add(label + ": " + msg);
                }
                break;
            }
            case API_MISMATCH: {
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled status: " + (Object)((Object)result.status()));
            }
        }
    }
}

