/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.grading;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openjdk.jcstress.annotations.Expect;
import org.openjdk.jcstress.infra.StateCase;
import org.openjdk.jcstress.infra.Status;
import org.openjdk.jcstress.infra.TestInfo;
import org.openjdk.jcstress.infra.collectors.TestResult;
import org.openjdk.jcstress.infra.grading.GradingResult;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.infra.runners.TestList;
import org.openjdk.jcstress.util.Environment;
import org.openjdk.jcstress.util.HashMultimap;
import org.openjdk.jcstress.util.HashMultiset;
import org.openjdk.jcstress.util.Multimap;
import org.openjdk.jcstress.util.StringUtils;

public class ReportUtils {
    public static List<TestResult> mergedByConfig(Collection<TestResult> src) {
        HashMultimap<TestConfig, TestResult> multiResults = new HashMultimap<TestConfig, TestResult>();
        for (TestResult r : src) {
            multiResults.put(r.getConfig(), r);
        }
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        for (TestConfig config : multiResults.keys()) {
            Collection<TestResult> mergeable = multiResults.get(config);
            TestResult root = ReportUtils.merged(config, mergeable);
            results.add(root);
        }
        return results;
    }

    public static List<TestResult> mergedByName(Collection<TestResult> src) {
        HashMultimap<String, TestResult> multiResults = new HashMultimap<String, TestResult>();
        for (TestResult r : src) {
            multiResults.put(r.getConfig().name, r);
        }
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        for (String name : multiResults.keys()) {
            Collection<TestResult> mergeable = multiResults.get(name);
            TestResult root = ReportUtils.merged(((TestResult)mergeable.iterator().next()).getConfig(), mergeable);
            results.add(root);
        }
        return results;
    }

    public static Multimap<String, TestResult> byName(Collection<TestResult> src) {
        HashMultimap<String, TestResult> result = new HashMultimap<String, TestResult>();
        for (TestResult r : ReportUtils.mergedByConfig(src)) {
            result.put(r.getName(), r);
        }
        return result;
    }

    private static TestResult merged(TestConfig config, Collection<TestResult> mergeable) {
        HashMultiset<String> stateCounts = new HashMultiset<String>();
        ArrayList<String> auxData = new ArrayList<String>();
        Status status = Status.NORMAL;
        Environment env = null;
        for (TestResult r : mergeable) {
            status = status.combine(r.status());
            for (String s : r.getStateKeys()) {
                stateCounts.add(s, r.getCount(s));
            }
            env = r.getEnv();
            auxData.addAll(r.getAuxData());
        }
        TestResult root = new TestResult(config, status, 0);
        for (String s : stateCounts.keys()) {
            root.addState(s, stateCounts.count(s));
        }
        root.setEnv(env);
        for (String data : auxData) {
            root.addAuxData(data);
        }
        return root;
    }

    public static void printDetails(PrintWriter pw, TestResult r, boolean inProgress) {
        if (inProgress) {
            pw.format("    (fork: #%d, iteration #%d, JVM args: %s)%n", r.getConfig().forkId + 1, r.getIteration(), r.getConfig().jvmArgs);
        } else {
            pw.format("    (JVM args: %s)%n", r.getConfig().jvmArgs);
        }
        int idLen = "Observed state".length();
        int occLen = "Occurrences".length();
        int expectLen = "Expectation".length();
        int descLen = 60;
        for (String s : r.getStateKeys()) {
            idLen = Math.max(idLen, s.length());
            occLen = Math.max(occLen, String.format("%,d", r.getCount(s)).length());
            expectLen = Math.max(expectLen, Expect.UNKNOWN.toString().length());
        }
        TestInfo test = TestList.getInfo(r.getName());
        for (StateCase c : test.cases()) {
            idLen = Math.max(idLen, c.matchPattern().length());
            expectLen = Math.max(expectLen, c.expect().toString().length());
        }
        expectLen = Math.max(expectLen, test.unmatched().expect().toString().length());
        pw.printf("%" + (idLen += 2) + "s %" + (occLen += 2) + "s %" + (expectLen += 2) + "s  %-" + descLen + "s%n", "Observed state", "Occurrences", "Expectation", "Interpretation");
        for (GradingResult gradeRes : r.grading().gradingResults) {
            pw.printf("%" + idLen + "s %," + occLen + "d %" + expectLen + "s  %-" + descLen + "s%n", new Object[]{StringUtils.cutoff(gradeRes.id, idLen), gradeRes.count, gradeRes.expect, StringUtils.cutoff(gradeRes.description, descLen)});
        }
        pw.println();
    }

    public static void printMessages(PrintWriter pw, TestResult r) {
        if (!r.getAuxData().isEmpty()) {
            pw.println("    Messages: ");
            for (String data : r.getAuxData()) {
                if (ReportUtils.skipMessage(data)) continue;
                pw.println("        " + data);
            }
            pw.println();
        }
    }

    private static boolean skipMessage(String data) {
        return data != null && data.startsWith("Warning: 'NoSuchMethodError' on register of sun.hotspot.WhiteBox");
    }

    public static String statusToLabel(TestResult result) {
        switch (result.status()) {
            case TIMEOUT_ERROR: {
                return "TIMEOUT";
            }
            case CHECK_TEST_ERROR: 
            case TEST_ERROR: {
                return "ERROR";
            }
            case VM_ERROR: {
                return "VM ERROR";
            }
            case API_MISMATCH: {
                return "SKIPPED";
            }
            case NORMAL: {
                if (result.grading().isPassed) {
                    return "OK";
                }
                return "FAILED";
            }
        }
        throw new IllegalStateException("Illegal status: " + (Object)((Object)result.status()));
    }

    public static boolean statusToPassed(TestResult result) {
        switch (result.status()) {
            case TIMEOUT_ERROR: 
            case CHECK_TEST_ERROR: 
            case TEST_ERROR: 
            case VM_ERROR: 
            case API_MISMATCH: {
                return false;
            }
            case NORMAL: {
                return result.grading().isPassed;
            }
        }
        throw new IllegalStateException("Illegal status: " + (Object)((Object)result.status()));
    }
}

