/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.grading;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openjdk.jcstress.annotations.Expect;
import org.openjdk.jcstress.infra.StateCase;
import org.openjdk.jcstress.infra.TestInfo;
import org.openjdk.jcstress.infra.collectors.TestResult;
import org.openjdk.jcstress.infra.grading.GradingResult;
import org.openjdk.jcstress.infra.runners.TestList;
import org.openjdk.jcstress.util.NonNullArrayList;

public class TestGrading {
    public boolean isPassed;
    public boolean hasInteresting;
    public final List<GradingResult> gradingResults;
    public final List<String> failureMessages;

    public static TestGrading grade(TestResult r) {
        return new TestGrading(r);
    }

    private TestGrading(TestResult r) {
        TestInfo test = TestList.getInfo(r.getName());
        this.gradingResults = new ArrayList<GradingResult>();
        this.failureMessages = new NonNullArrayList<String>();
        this.isPassed = true;
        this.hasInteresting = false;
        ArrayList<StateCase> unmatchedStates = new ArrayList<StateCase>();
        unmatchedStates.addAll(test.cases());
        for (String s : r.getStateKeys()) {
            StateCase matched = null;
            for (StateCase c2 : test.cases()) {
                if (!c2.matchesExactly(s)) continue;
                matched = c2;
                break;
            }
            if (matched == null) {
                for (StateCase c2 : test.cases()) {
                    if (!c2.matches(s)) continue;
                    matched = c2;
                    break;
                }
            }
            if (matched != null) {
                unmatchedStates.remove(matched);
            } else {
                matched = test.unmatched();
            }
            long count = r.getCount(s);
            Expect ex = matched.expect();
            this.isPassed &= TestGrading.passed(ex, count);
            this.hasInteresting |= TestGrading.hasInteresting(ex, count);
            this.failureMessages.add(TestGrading.failureMessage(s, ex, count, matched.description()));
            this.gradingResults.add(new GradingResult(s, matched.expect(), count, matched.description()));
        }
        for (StateCase c3 : unmatchedStates) {
            Expect ex = c3.expect();
            this.isPassed &= TestGrading.passed(ex, 0L);
            this.hasInteresting |= TestGrading.hasInteresting(ex, 0L);
            this.failureMessages.add(TestGrading.failureMessage("N/A", ex, 0L, c3.description()));
            this.gradingResults.add(new GradingResult(c3.matchPattern(), ex, 0L, c3.description()));
        }
        Collections.sort(this.gradingResults, Comparator.comparing(c -> c.id));
    }

    public static String failureMessage(String id, Expect expect, long count, String description) {
        if (TestGrading.passed(expect, count)) {
            return null;
        }
        switch (expect) {
            case ACCEPTABLE: 
            case ACCEPTABLE_INTERESTING: {
                return null;
            }
            case FORBIDDEN: {
                return "Observed forbidden state: " + id + (description == null ? "" : " (" + description + ")");
            }
            case UNKNOWN: {
                return "Missing description";
            }
        }
        return "Missing grading";
    }

    public static boolean passed(Expect expect, long count) {
        switch (expect) {
            case ACCEPTABLE: 
            case ACCEPTABLE_INTERESTING: {
                return true;
            }
            case FORBIDDEN: {
                return count == 0L;
            }
            case UNKNOWN: {
                return false;
            }
        }
        throw new IllegalStateException("No grading for expect type = " + (Object)((Object)expect));
    }

    private static boolean hasInteresting(Expect expect, long count) {
        switch (expect) {
            case ACCEPTABLE: 
            case FORBIDDEN: {
                return false;
            }
            case ACCEPTABLE_INTERESTING: {
                return count != 0L;
            }
            case UNKNOWN: {
                return false;
            }
        }
        throw new IllegalStateException("No grading for expect type = " + (Object)((Object)expect));
    }
}

