/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.grading;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.openjdk.jcstress.Options;
import org.openjdk.jcstress.infra.Status;
import org.openjdk.jcstress.infra.collectors.InProcessCollector;
import org.openjdk.jcstress.infra.collectors.TestResult;
import org.openjdk.jcstress.infra.grading.ReportUtils;
import org.openjdk.jcstress.util.StringUtils;

public class TextReportPrinter {
    private final InProcessCollector collector;
    private final boolean verbose;
    private final PrintWriter pw;
    private final Set<TestResult> emittedTests;

    public TextReportPrinter(Options opts, InProcessCollector collector) throws FileNotFoundException {
        this.collector = collector;
        this.pw = new PrintWriter(System.out, true);
        this.verbose = opts.isVerbose();
        this.emittedTests = new HashSet<TestResult>();
    }

    public void work() throws FileNotFoundException {
        this.emittedTests.clear();
        List<TestResult> byConfig = ReportUtils.mergedByConfig(this.collector.getTestResults());
        Collections.sort(byConfig, Comparator.comparing(TestResult::getName).thenComparing(Comparator.comparing(t -> t.getConfig().jvmArgs.toString())));
        this.pw.println("RUN RESULTS:");
        this.pw.println("------------------------------------------------------------------------------------------------------------------------");
        this.pw.println();
        this.printXTests(byConfig, "INTERESTING tests", "Some interesting behaviors observed. This is for the plain curiosity.", r -> r.status() == Status.NORMAL && r.grading().hasInteresting, true);
        this.printXTests(byConfig, "FAILED tests", "Strong asserts were violated. Correct implementations should have no assert failures here.", r -> r.status() == Status.NORMAL && !r.grading().isPassed, true);
        this.printXTests(byConfig, "ERROR tests", "Tests break for some reason, other than failing the assert. Correct implementations should have none.", r -> r.status() != Status.NORMAL && r.status() != Status.API_MISMATCH, true);
        this.printXTests(byConfig, "All remaining tests", "Tests that do not fall into any of the previous categories.", r -> !this.emittedTests.contains(r), this.verbose);
        this.pw.println("------------------------------------------------------------------------------------------------------------------------");
    }

    private void printXTests(List<TestResult> list, String header, String subHeader, Predicate<TestResult> predicate, boolean emitDetails) {
        this.pw.println("*** " + header);
        this.pw.println("  " + subHeader);
        this.pw.println();
        this.pw.println("  " + list.stream().filter(predicate).count() + " matching test results. " + (!emitDetails ? " Use -v to print them." : ""));
        if (emitDetails) {
            for (TestResult result : list) {
                if (!predicate.test(result)) continue;
                this.emitTest(result);
            }
        }
        this.pw.println();
    }

    public void emitTest(TestResult result) {
        this.emittedTests.add(result);
        this.pw.printf("%10s %s%n", "[" + ReportUtils.statusToLabel(result) + "]", StringUtils.chunkName(result.getName()));
        ReportUtils.printDetails(this.pw, result, false);
        ReportUtils.printMessages(this.pw, result);
    }
}

