/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.processors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.openjdk.jcstress.annotations.Actor;
import org.openjdk.jcstress.annotations.Arbiter;
import org.openjdk.jcstress.annotations.Description;
import org.openjdk.jcstress.annotations.JCStressMeta;
import org.openjdk.jcstress.annotations.JCStressTest;
import org.openjdk.jcstress.annotations.Mode;
import org.openjdk.jcstress.annotations.Outcome;
import org.openjdk.jcstress.annotations.Ref;
import org.openjdk.jcstress.annotations.Result;
import org.openjdk.jcstress.annotations.Signal;
import org.openjdk.jcstress.annotations.State;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;
import org.openjdk.jcstress.infra.processors.GenerationException;
import org.openjdk.jcstress.infra.processors.TestInfo;
import org.openjdk.jcstress.infra.runners.Runner;
import org.openjdk.jcstress.infra.runners.StateHolder;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.util.Counter;
import org.openjdk.jcstress.util.Paddings;
import org.openjdk.jcstress.util.TestLineWriter;
import org.openjdk.jcstress.vm.WhiteBoxSupport;

public class JCStressTestProcessor
extends AbstractProcessor {
    private final List<TestInfo> tests = new ArrayList<TestInfo>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(JCStressTest.class.getName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(JCStressTest.class);
            for (Element element : set) {
                TypeElement e = (TypeElement)element;
                try {
                    TestInfo info = this.parseAndValidate(e);
                    Mode mode = element.getAnnotation(JCStressTest.class).value();
                    switch (mode) {
                        case Continuous: {
                            this.generateContinuous(info);
                            break;
                        }
                        case Termination: {
                            this.generateTermination(info);
                            break;
                        }
                        default: {
                            throw new GenerationException("Unknown mode: " + (Object)((Object)mode), e);
                        }
                    }
                    this.tests.add(info);
                }
                catch (GenerationException ex) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), ex.getElement());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            try {
                FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "/META-INF/TestList".substring(1), new Element[0]);
                PrintWriter writer = new PrintWriter(file.openWriter());
                for (TestInfo test : this.tests) {
                    TestLineWriter wl = new TestLineWriter();
                    wl.put(test.getTest().getQualifiedName());
                    wl.put(test.getGeneratedName());
                    wl.put(test.getDescription());
                    wl.put(test.getActors().size());
                    wl.put(test.isRequiresFork());
                    wl.put(test.cases().size());
                    for (Outcome c : test.cases()) {
                        wl.put((Object)c.expect());
                        wl.put(c.desc());
                        wl.put(c.id().length);
                        for (String id : c.id()) {
                            wl.put(id);
                        }
                    }
                    wl.put(test.refs().size());
                    for (String ref : test.refs()) {
                        wl.put(ref);
                    }
                    writer.println(wl.get());
                }
                writer.close();
            }
            catch (IOException ex) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error writing MicroBenchmark list " + ex);
            }
        }
        return true;
    }

    private TestInfo parseAndValidate(TypeElement e) {
        TestInfo info = new TestInfo();
        info.setTest(e);
        String gradingName = JCStressMeta.class.getName();
        block0: for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            if (!gradingName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"value".equals(entry.getKey().getSimpleName().toString())) continue;
                AnnotationValue value = entry.getValue();
                this.parseMeta(this.processingEnv.getElementUtils().getTypeElement(value.getValue().toString()), info);
                continue block0;
            }
        }
        this.parseMeta(e, info);
        for (ExecutableElement executableElement : ElementFilter.methodsIn(e.getEnclosedElements())) {
            if (executableElement.getAnnotation(Actor.class) != null) {
                info.addActor(executableElement);
            }
            if (executableElement.getAnnotation(Arbiter.class) != null) {
                info.setArbiter(executableElement);
            }
            if (executableElement.getAnnotation(Signal.class) != null) {
                info.setSignal(executableElement);
            }
            if (executableElement.getAnnotation(Actor.class) == null && executableElement.getAnnotation(Arbiter.class) == null && executableElement.getAnnotation(Signal.class) == null) continue;
            for (VariableElement variableElement : executableElement.getParameters()) {
                TypeElement paramClass = (TypeElement)this.processingEnv.getTypeUtils().asElement(variableElement.asType());
                if (paramClass.getAnnotation(State.class) != null) {
                    info.setState(paramClass);
                    continue;
                }
                if (paramClass.getAnnotation(Result.class) != null) {
                    info.setResult(paramClass);
                    continue;
                }
                if (e.getAnnotation(JCStressTest.class).value() == Mode.Termination && paramClass.getQualifiedName().toString().equals("java.lang.Thread")) continue;
                throw new GenerationException("The parameter for @" + Actor.class.getSimpleName() + " methods requires either @" + State.class.getSimpleName() + " or @" + Result.class.getSimpleName() + " annotated class", variableElement);
            }
        }
        if (e.getAnnotation(State.class) != null) {
            info.setState(e);
        } else if (e.getAnnotation(Result.class) != null) {
            info.setResult(e);
        }
        String packageName = this.getPackageName(info.getTest());
        String string = JCStressTestProcessor.getGeneratedName(info.getTest());
        info.setGeneratedName(packageName + "." + string);
        info.setRequiresFork(e.getAnnotation(JCStressTest.class).value() == Mode.Termination);
        return info;
    }

    private void parseMeta(TypeElement e, TestInfo info) {
        Description d;
        Ref ref;
        Ref.Refs refs;
        Outcome outcome;
        Outcome.Outcomes outcomes = e.getAnnotation(Outcome.Outcomes.class);
        if (outcomes != null) {
            for (Outcome c : outcomes.value()) {
                info.addCase(c);
            }
        }
        if ((outcome = e.getAnnotation(Outcome.class)) != null) {
            info.addCase(outcome);
        }
        if ((refs = e.getAnnotation(Ref.Refs.class)) != null) {
            for (Ref r : refs.value()) {
                info.addRef(r.value());
            }
        }
        if ((ref = e.getAnnotation(Ref.class)) != null) {
            info.addRef(ref.value());
        }
        if ((d = e.getAnnotation(Description.class)) != null) {
            info.setDescription(d.value());
        }
    }

    public static String getGeneratedName(Element ci) {
        String name = "";
        do {
            name = ci.getSimpleName() + (name.isEmpty() ? "" : "_" + name);
        } while ((ci = ci.getEnclosingElement()) != null && ci.getKind() != ElementKind.PACKAGE);
        return name + "_jcstress";
    }

    public static String getQualifiedName(Element ci) {
        String name = "";
        while (true) {
            Element parent;
            if ((parent = ci.getEnclosingElement()) == null || parent.getKind() == ElementKind.PACKAGE) break;
            name = ci.getSimpleName() + (name.isEmpty() ? "" : "." + name);
            ci = parent;
        }
        name = ((TypeElement)ci).getQualifiedName() + (name.isEmpty() ? "" : "." + name);
        return name;
    }

    private void generateContinuous(TestInfo info) {
        PrintWriter pw;
        if (info.getState() == null) {
            throw new GenerationException("@" + JCStressTest.class.getSimpleName() + " defines no @" + State.class.getSimpleName() + " to work with", info.getTest());
        }
        if (info.getResult() == null) {
            throw new GenerationException("@" + JCStressTest.class.getSimpleName() + " defines no @" + Result.class.getSimpleName() + " to work with", info.getTest());
        }
        if (info.getState().getModifiers().contains((Object)Modifier.FINAL)) {
            throw new GenerationException("@" + State.class.getSimpleName() + " should not be final.", info.getState());
        }
        if (info.getResult().getModifiers().contains((Object)Modifier.FINAL)) {
            throw new GenerationException("@" + Result.class.getSimpleName() + " should not be final.", info.getResult());
        }
        if (!info.getState().getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new GenerationException("@" + State.class.getSimpleName() + " should be public.", info.getState());
        }
        if (!info.getResult().getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new GenerationException("@" + Result.class.getSimpleName() + " should be public.", info.getResult());
        }
        if (!info.getResult().getSuperclass().toString().equals("java.lang.Object")) {
            throw new GenerationException("@" + Result.class.getSimpleName() + " should not inherit other classes.", info.getResult());
        }
        String className = JCStressTestProcessor.getGeneratedName(info.getTest());
        try {
            Writer writer = this.processingEnv.getFiler().createSourceFile(this.getPackageName(info.getTest()) + "." + className, new Element[0]).openWriter();
            pw = new PrintWriter(writer);
        }
        catch (IOException e) {
            throw new GenerationException("IOException: " + e.getMessage(), info.getTest());
        }
        boolean isStateItself = info.getState().equals(info.getTest());
        String t = info.getTest().getSimpleName().toString();
        String s = isStateItself ? info.getState().getSimpleName().toString() : JCStressTestProcessor.getGeneratedName(info.getState());
        String r = JCStressTestProcessor.getGeneratedName(info.getResult());
        this.generateTrapSubclass(info.getResult());
        if (!isStateItself) {
            this.generateTrapSubclass(info.getState());
        }
        int actorsCount = info.getActors().size();
        pw.println("package " + this.getPackageName(info.getTest()) + ";");
        this.printImports(pw, info);
        pw.println("public class " + className + " extends Runner<" + r + "> {");
        pw.println();
        if (!isStateItself) {
            pw.println("    " + t + " test;");
        }
        pw.println("    volatile StateHolder<" + s + ", " + r + "> version;");
        pw.println();
        pw.println("    public " + className + "(TestConfig config, TestResultCollector collector, ExecutorService pool) {");
        pw.println("        super(config, collector, pool, \"" + JCStressTestProcessor.getQualifiedName(info.getTest()) + "\");");
        pw.println("    }");
        pw.println();
        pw.println("    @Override");
        pw.println("    public Counter<" + r + "> sanityCheck() throws Throwable {");
        pw.println("        Counter<" + r + "> counter = new Counter<>();");
        pw.println("        sanityCheck_API(counter);");
        pw.println("        sanityCheck_Footprints(counter);");
        pw.println("        return counter;");
        pw.println("    }");
        pw.println();
        pw.println("    private void sanityCheck_API(Counter<" + r + "> counter) throws Throwable {");
        pw.println("        final " + s + " s = new " + s + "();");
        pw.println("        final " + r + " r = new " + r + "();");
        if (!isStateItself) {
            pw.println("        final " + t + " t = new " + t + "();");
        }
        pw.println("        Collection<Future<?>> res = new ArrayList<>();");
        for (ExecutableElement el : info.getActors()) {
            pw.print("        res.add(pool.submit(() -> ");
            this.emitMethod(pw, el, (isStateItself ? "s." : "t.") + el.getSimpleName(), "s", "r", false);
            pw.println("));");
        }
        pw.println("        for (Future<?> f : res) {");
        pw.println("            try {");
        pw.println("                f.get();");
        pw.println("            } catch (ExecutionException e) {");
        pw.println("                throw e.getCause();");
        pw.println("            }");
        pw.println("        }");
        if (info.getArbiter() != null) {
            pw.println("        try {");
            pw.print("            pool.submit(() ->");
            this.emitMethod(pw, info.getArbiter(), (isStateItself ? "s." : "t.") + info.getArbiter().getSimpleName(), "s", "r", false);
            pw.println(").get();");
            pw.println("        } catch (ExecutionException e) {");
            pw.println("            throw e.getCause();");
            pw.println("        }");
        }
        pw.println("        counter.record(r);");
        pw.println("    }");
        pw.println();
        pw.println("    private void sanityCheck_Footprints(Counter<" + r + "> counter) throws Throwable {");
        pw.println("        config.adjustStrides(size -> {");
        pw.println("            version = new StateHolder<>(new " + s + "[size], new " + r + "[size], " + actorsCount + ", config.spinLoopStyle);");
        if (!isStateItself) {
            pw.println("            final " + t + " t = new " + t + "();");
        }
        pw.println("            for (int c = 0; c < size; c++) {");
        pw.println("                " + r + " r = new " + r + "();");
        pw.println("                " + s + " s = new " + s + "();");
        pw.println("                version.rs[c] = r;");
        pw.println("                version.ss[c] = s;");
        for (ExecutableElement el : info.getActors()) {
            pw.print("                ");
            if (isStateItself) {
                this.emitMethod(pw, el, "s." + el.getSimpleName(), "s", "r", false);
            } else {
                this.emitMethod(pw, el, "t." + el.getSimpleName(), "s", "r", false);
            }
            pw.println(";");
        }
        if (info.getArbiter() != null) {
            pw.print("                ");
            this.emitMethod(pw, info.getArbiter(), (isStateItself ? "s." : "t.") + info.getArbiter().getSimpleName(), "s", "r", true);
        }
        pw.println("                counter.record(r);");
        pw.println("            }");
        pw.println("        });");
        pw.println("    }");
        pw.println();
        pw.println("    @Override");
        pw.println("    public Counter<" + r + "> internalRun() {");
        if (!isStateItself) {
            pw.println("        test = new " + t + "();");
        }
        pw.println("        version = new StateHolder<>(new " + s + "[0], new " + r + "[0], " + actorsCount + ", config.spinLoopStyle);");
        pw.println();
        pw.println("        control.isStopped = false;");
        pw.println();
        pw.println("        List<Callable<Counter<" + r + ">>> tasks = new ArrayList<>();");
        for (ExecutableElement a : info.getActors()) {
            pw.println("        tasks.add(this::" + a.getSimpleName() + ");");
        }
        pw.println("        Collections.shuffle(tasks);");
        pw.println();
        pw.println("        Collection<Future<Counter<" + r + ">>> results = new ArrayList<>();");
        pw.println("        for (Callable<Counter<" + r + ">> task : tasks) {");
        pw.println("            results.add(pool.submit(task));");
        pw.println("        }");
        pw.println();
        pw.println("        try {");
        pw.println("            TimeUnit.MILLISECONDS.sleep(config.time);");
        pw.println("        } catch (InterruptedException e) {");
        pw.println("        }");
        pw.println();
        pw.println("        control.isStopped = true;");
        pw.println();
        pw.println("        waitFor(results);");
        pw.println();
        pw.println("        Counter<" + r + "> counter = new Counter<>();");
        pw.println("        for (Future<Counter<" + r + ">> f : results) {");
        pw.println("            try {");
        pw.println("                counter.merge(f.get());");
        pw.println("            } catch (Throwable e) {");
        pw.println("                throw new IllegalStateException(e);");
        pw.println("            }");
        pw.println("        }");
        pw.println("        return counter;");
        pw.println("    }");
        pw.println();
        pw.println("    public final void jcstress_consume(StateHolder<" + s + ", " + r + "> holder, Counter<" + r + "> cnt, int a, int actors) {");
        pw.println("        " + s + "[] ss = holder.ss;");
        pw.println("        " + r + "[] rs = holder.rs;");
        pw.println("        int len = ss.length;");
        pw.println("        int left = a * len / actors;");
        pw.println("        int right = (a + 1) * len / actors;");
        pw.println("        for (int c = left; c < right; c++) {");
        pw.println("            " + r + " r = rs[c];");
        pw.println("            " + s + " s = ss[c];");
        if (info.getArbiter() != null) {
            if (isStateItself) {
                this.emitMethod(pw, info.getArbiter(), "            s." + info.getArbiter().getSimpleName(), "s", "r", true);
            } else {
                this.emitMethod(pw, info.getArbiter(), "            test." + info.getArbiter().getSimpleName(), "s", "r", true);
            }
        }
        if (this.allFieldsAreDefault(info.getState())) {
            for (VariableElement var : ElementFilter.fieldsIn(info.getState().getEnclosedElements())) {
                if (var.getModifiers().contains((Object)Modifier.STATIC)) continue;
                pw.print("            s." + var.getSimpleName().toString() + " = ");
                pw.print(this.getDefaultVal(var));
                pw.println(";");
            }
        } else {
            pw.println("            ss[c] = new " + s + "();");
        }
        pw.println("            cnt.record(r);");
        for (VariableElement var : ElementFilter.fieldsIn(info.getResult().getEnclosedElements())) {
            pw.print("            r." + var.getSimpleName().toString() + " = ");
            pw.print(this.getDefaultVal(var));
            pw.println(";");
        }
        pw.println("        }");
        pw.println("    }");
        pw.println();
        pw.println("    public final void jcstress_updateHolder(StateHolder<" + s + ", " + r + "> holder) {");
        pw.println("        if (!holder.tryStartUpdate()) return;");
        pw.println("        " + s + "[] ss = holder.ss;");
        pw.println("        " + r + "[] rs = holder.rs;");
        pw.println("        int len = ss.length;");
        pw.println();
        pw.println("        int newLen = holder.updateStride ? Math.max(config.minStride, Math.min(len * 2, config.maxStride)) : len;");
        pw.println();
        pw.println("        " + s + "[] newS = ss;");
        pw.println("        " + r + "[] newR = rs;");
        pw.println("        if (newLen > len) {");
        pw.println("            newS = Arrays.copyOf(ss, newLen);");
        pw.println("            newR = Arrays.copyOf(rs, newLen);");
        pw.println("            for (int c = len; c < newLen; c++) {");
        pw.println("                newR[c] = new " + r + "();");
        pw.println("                newS[c] = new " + s + "();");
        pw.println("            }");
        pw.println("         }");
        pw.println();
        pw.println("        version = new StateHolder<>(control.isStopped, newS, newR, " + actorsCount + ", config.spinLoopStyle);");
        pw.println("        holder.finishUpdate();");
        pw.println("   }");
        int n = 0;
        for (ExecutableElement a : info.getActors()) {
            pw.println();
            pw.println("    public final Counter<" + r + "> " + a.getSimpleName() + "() {");
            pw.println();
            if (!isStateItself) {
                pw.println("        " + t + " lt = test;");
            }
            pw.println("        Counter<" + r + "> counter = new Counter<>();");
            pw.println("        while (true) {");
            pw.println("            StateHolder<" + s + "," + r + "> holder = version;");
            pw.println("            if (holder.stopped) {");
            pw.println("                return counter;");
            pw.println("            }");
            pw.println();
            pw.println("            " + s + "[] ss = holder.ss;");
            pw.println("            " + r + "[] rs = holder.rs;");
            pw.println("            int size = ss.length;");
            pw.println();
            pw.println("            holder.preRun();");
            pw.println();
            pw.println("            for (int c = 0; c < size; c++) {");
            pw.println("                " + s + " s = ss[c];");
            if (this.hasResultArgs(a)) {
                pw.println("                " + r + " r = rs[c];");
                pw.println("                r.trap = 0;");
            }
            if (isStateItself) {
                this.emitMethod(pw, a, "                s." + a.getSimpleName(), "s", "r", true);
            } else {
                pw.println("                s.trap = 0;");
                this.emitMethod(pw, a, "                lt." + a.getSimpleName(), "s", "r", true);
            }
            pw.println("            }");
            pw.println();
            pw.println("            holder.postRun();");
            pw.println();
            pw.println("            jcstress_consume(holder, counter, " + n + ", " + actorsCount + ");");
            pw.println("            jcstress_updateHolder(holder);");
            pw.println();
            pw.println("            holder.postUpdate();");
            pw.println("        }");
            pw.println("    }");
            ++n;
        }
        pw.println();
        pw.println("}");
        pw.close();
    }

    private boolean allFieldsAreDefault(TypeElement el) {
        if (!el.getSuperclass().toString().equals("java.lang.Object")) {
            return false;
        }
        for (VariableElement v : ElementFilter.fieldsIn(el.getEnclosedElements())) {
            Set<Modifier> mods = v.getModifiers();
            if (mods.contains((Object)Modifier.STATIC)) continue;
            if (mods.contains((Object)Modifier.FINAL)) {
                return false;
            }
            if (mods.contains((Object)Modifier.PRIVATE)) {
                return false;
            }
            if (!mods.contains((Object)Modifier.PROTECTED)) continue;
            return false;
        }
        Trees trees = Trees.instance(this.processingEnv);
        ClassTree tree = trees.getTree(el);
        if (tree == null) {
            return false;
        }
        for (Tree tree2 : tree.getMembers()) {
            VariableTree t;
            MethodTree m;
            if (tree2.getKind() == Tree.Kind.METHOD && (m = (MethodTree)tree2).getName().toString().equals("<init>")) {
                BlockTree body = m.getBody();
                List<? extends StatementTree> b = body.getStatements();
                if (b.size() != 1) {
                    return false;
                }
                if (!b.get(0).toString().equals("super();")) {
                    return false;
                }
            }
            if (tree2.getKind() == Tree.Kind.VARIABLE && (t = (VariableTree)tree2).getInitializer() != null) {
                return false;
            }
            if (tree2.getKind() != Tree.Kind.BLOCK) continue;
            return false;
        }
        return true;
    }

    private void generateTrapSubclass(TypeElement el) {
        PrintWriter pw;
        String name = JCStressTestProcessor.getGeneratedName(el);
        try {
            Writer writer = this.processingEnv.getFiler().createSourceFile(this.getPackageName(el) + "." + name, new Element[0]).openWriter();
            pw = new PrintWriter(writer);
        }
        catch (IOException e) {
            return;
        }
        pw.println("package " + this.getPackageName(el) + ";");
        pw.println("class " + name + "_c2 extends " + el.getQualifiedName() + " {");
        Paddings.padding(pw);
        pw.println("}");
        pw.println("class " + name + "_c1 extends " + name + "_c2 {");
        pw.println("    public int trap;");
        pw.println("}");
        pw.println("public class " + name + " extends " + name + "_c1 {");
        Paddings.padding(pw);
        pw.println("}");
        pw.close();
    }

    private String getDefaultVal(VariableElement var) {
        String val;
        String type;
        switch (type = var.asType().toString()) {
            case "int": 
            case "long": 
            case "short": 
            case "byte": 
            case "char": {
                val = "0";
                break;
            }
            case "double": {
                val = "0D";
                break;
            }
            case "float": {
                val = "0F";
                break;
            }
            case "boolean": {
                val = "false";
                break;
            }
            default: {
                val = "null";
            }
        }
        return val;
    }

    private void generateTermination(TestInfo info) {
        PrintWriter pw;
        if (info.getSignal() == null) {
            throw new GenerationException("@" + JCStressTest.class.getSimpleName() + " with mode=" + (Object)((Object)Mode.Termination) + " should have a @" + Signal.class.getSimpleName() + " method", info.getTest());
        }
        if (info.getActors().size() != 1) {
            throw new GenerationException("@" + JCStressTest.class.getSimpleName() + " with mode=" + (Object)((Object)Mode.Termination) + " should have only the single @" + Actor.class.getName(), info.getTest());
        }
        String generatedName = JCStressTestProcessor.getGeneratedName(info.getTest());
        try {
            Writer writer = this.processingEnv.getFiler().createSourceFile(this.getPackageName(info.getTest()) + "." + generatedName, new Element[0]).openWriter();
            pw = new PrintWriter(writer);
        }
        catch (IOException e) {
            throw new GenerationException("IOException: " + e.getMessage(), info.getTest());
        }
        String t = info.getTest().getSimpleName().toString();
        ExecutableElement actor = info.getActors().get(0);
        pw.println("package " + this.getPackageName(info.getTest()) + ";");
        this.printImports(pw, info);
        pw.println("public class " + generatedName + " extends Runner<" + generatedName + ".Outcome> {");
        pw.println();
        pw.println("    public " + generatedName + "(TestConfig config, TestResultCollector collector, ExecutorService pool) {");
        pw.println("        super(config, collector, pool, \"" + JCStressTestProcessor.getQualifiedName(info.getTest()) + "\");");
        pw.println("    }");
        pw.println();
        pw.println("    @Override");
        pw.println("    public void run() {");
        pw.println("        Counter<Outcome> results = new Counter<>();");
        pw.println();
        pw.println("        for (int c = 0; c < config.iters; c++) {");
        pw.println("            try {");
        pw.println("                WhiteBoxSupport.tryDeopt(config.deoptRatio);");
        pw.println("            } catch (NoClassDefFoundError err) {");
        pw.println("                // gracefully \"handle\"");
        pw.println("            }");
        pw.println();
        pw.println("            run(results);");
        pw.println();
        pw.println("            if (results.count(Outcome.STALE) > 0) {");
        pw.println("                messages.add(\"Have stale threads, forcing VM to exit for proper cleanup.\");");
        pw.println("                dump(c, results);");
        pw.println("                System.exit(0);");
        pw.println("            } else {");
        pw.println("                dump(c, results);");
        pw.println("            }");
        pw.println("        }");
        pw.println("    }");
        pw.println();
        pw.println("    @Override");
        pw.println("    public Counter<Outcome> sanityCheck() throws Throwable {");
        pw.println("        throw new UnsupportedOperationException();");
        pw.println("    }");
        pw.println();
        pw.println("    @Override");
        pw.println("    public Counter<Outcome> internalRun() {");
        pw.println("        throw new UnsupportedOperationException();");
        pw.println("    }");
        pw.println();
        pw.println("    private void run(Counter<Outcome> results) {");
        pw.println("        long target = System.currentTimeMillis() + config.time;");
        pw.println("        while (System.currentTimeMillis() < target) {");
        pw.println();
        if (info.getTest().equals(info.getState())) {
            pw.println("            final " + info.getState().getSimpleName() + " state = new " + info.getState().getSimpleName() + "();");
        } else {
            if (info.getState() != null) {
                pw.println("            final " + info.getState().getSimpleName() + " state = new " + info.getState().getSimpleName() + "();");
            }
            pw.println("            final " + t + " test = new " + t + "();");
        }
        pw.println("            final Holder holder = new Holder();");
        pw.println();
        pw.println("            Thread t1 = new Thread(new Runnable() {");
        pw.println("                public void run() {");
        pw.println("                    try {");
        pw.println("                        holder.started = true;");
        if (info.getTest().equals(info.getState())) {
            this.emitMethodTermination(pw, actor, "                        state." + actor.getSimpleName(), "state");
        } else {
            this.emitMethodTermination(pw, actor, "                        test." + actor.getSimpleName(), "state");
        }
        pw.println("                    } catch (Exception e) {");
        pw.println("                        holder.error = true;");
        pw.println("                    }");
        pw.println("                    holder.terminated = true;");
        pw.println("                }");
        pw.println("            });");
        pw.println("            t1.setDaemon(true);");
        pw.println("            t1.start();");
        pw.println();
        pw.println("            while (!holder.started) {");
        pw.println("                try {");
        pw.println("                    TimeUnit.MILLISECONDS.sleep(1);");
        pw.println("                } catch (InterruptedException e) {");
        pw.println("                    // do nothing");
        pw.println("                }");
        pw.println("            }");
        pw.println();
        pw.println("            try {");
        if (info.getTest().equals(info.getState())) {
            this.emitMethodTermination(pw, info.getSignal(), "                state." + info.getSignal().getSimpleName(), "state");
        } else {
            this.emitMethodTermination(pw, info.getSignal(), "                test." + info.getSignal().getSimpleName(), "state");
        }
        pw.println("            } catch (Exception e) {");
        pw.println("                holder.error = true;");
        pw.println("            }");
        pw.println();
        pw.println("            try {");
        pw.println("                t1.join(Math.max(2*config.time, Runner.MIN_TIMEOUT_MS));");
        pw.println("            } catch (InterruptedException e) {");
        pw.println("                // do nothing");
        pw.println("            }");
        pw.println();
        pw.println("            if (holder.terminated) {");
        pw.println("                if (holder.error) {");
        pw.println("                    results.record(Outcome.ERROR);");
        pw.println("                } else {");
        pw.println("                    results.record(Outcome.TERMINATED);");
        pw.println("                }");
        pw.println("            } else {");
        pw.println("                results.record(Outcome.STALE);");
        pw.println("                return;");
        pw.println("            }");
        pw.println("        }");
        pw.println("    }");
        pw.println();
        pw.println("    private static class Holder {");
        pw.println("        volatile boolean started;");
        pw.println("        volatile boolean terminated;");
        pw.println("        volatile boolean error;");
        pw.println("    }");
        pw.println();
        pw.println("    public enum Outcome {");
        pw.println("        TERMINATED,");
        pw.println("        STALE,");
        pw.println("        ERROR,");
        pw.println("    }");
        pw.println("}");
        pw.close();
    }

    private boolean hasResultArgs(ExecutableElement el) {
        for (VariableElement variableElement : el.getParameters()) {
            TypeElement paramClass = (TypeElement)this.processingEnv.getTypeUtils().asElement(variableElement.asType());
            if (paramClass.getAnnotation(Result.class) == null) continue;
            return true;
        }
        return false;
    }

    private void emitMethod(PrintWriter pw, ExecutableElement el, String lvalue, String stateAccessor, String resultAccessor, boolean terminate) {
        pw.print(lvalue + "(");
        boolean isFirst = true;
        for (VariableElement variableElement : el.getParameters()) {
            if (isFirst) {
                isFirst = false;
            } else {
                pw.print(", ");
            }
            TypeElement paramClass = (TypeElement)this.processingEnv.getTypeUtils().asElement(variableElement.asType());
            if (paramClass.getAnnotation(State.class) != null) {
                pw.print(stateAccessor);
                continue;
            }
            if (paramClass.getAnnotation(Result.class) == null) continue;
            pw.print(resultAccessor);
        }
        pw.print(")");
        if (terminate) {
            pw.println(";");
        }
    }

    private void emitMethodTermination(PrintWriter pw, ExecutableElement el, String lvalue, String stateAccessor) {
        pw.print(lvalue + "(");
        boolean isFirst = true;
        for (VariableElement variableElement : el.getParameters()) {
            if (isFirst) {
                isFirst = false;
            } else {
                pw.print(", ");
            }
            TypeElement paramClass = (TypeElement)this.processingEnv.getTypeUtils().asElement(variableElement.asType());
            if (paramClass.getAnnotation(State.class) != null) {
                pw.print(stateAccessor);
            }
            if (!paramClass.getQualifiedName().toString().equals("java.lang.Thread")) continue;
            pw.print("t1");
        }
        pw.println(");");
    }

    private void printImports(PrintWriter pw, TestInfo info) {
        Class[] imports;
        for (Class c : imports = new Class[]{ArrayList.class, Arrays.class, Collection.class, ExecutorService.class, Future.class, TimeUnit.class, TestConfig.class, TestResultCollector.class, Runner.class, StateHolder.class, Counter.class, WhiteBoxSupport.class, ExecutionException.class, Callable.class, Collections.class, List.class}) {
            pw.println("import " + c.getName() + ';');
        }
        pw.println("import " + info.getTest().getQualifiedName() + ";");
        if (info.getResult() != null) {
            pw.println("import " + info.getResult().getQualifiedName() + "_jcstress;");
        }
        if (!info.getTest().equals(info.getState()) && info.getState() != null) {
            pw.println("import " + this.getPackageName(info.getState()) + "." + JCStressTestProcessor.getGeneratedName(info.getState()) + ";");
        }
        pw.println();
    }

    public String getPackageName(Element el) {
        Element walk = el;
        while (walk.getKind() != ElementKind.PACKAGE) {
            walk = walk.getEnclosingElement();
        }
        return ((PackageElement)walk).getQualifiedName().toString();
    }
}

