/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.openjdk.jcstress.annotations.Arbiter;
import org.openjdk.jcstress.annotations.Outcome;
import org.openjdk.jcstress.annotations.Result;
import org.openjdk.jcstress.annotations.Signal;
import org.openjdk.jcstress.annotations.State;
import org.openjdk.jcstress.infra.processors.GenerationException;

public class TestInfo {
    private List<ExecutableElement> actors = new ArrayList<ExecutableElement>();
    private TypeElement state;
    private TypeElement result;
    private ExecutableElement arbiter;
    private TypeElement test;
    private ExecutableElement signal;
    private String generatedName;
    private boolean requiresFork;
    private Collection<Outcome> outcomes = new ArrayList<Outcome>();
    private Collection<String> refs = new ArrayList<String>();
    private String description;

    public TestInfo() {
        this.actors = new ArrayList<ExecutableElement>();
    }

    public void addActor(ExecutableElement element) {
        this.actors.add(element);
    }

    public void setState(TypeElement element) {
        if (this.state != null && !this.state.equals(element)) {
            throw new GenerationException("We can only have a single @" + State.class.getSimpleName() + " per test.", element);
        }
        this.state = element;
    }

    public void setArbiter(ExecutableElement element) {
        if (this.arbiter != null && !this.arbiter.equals(element)) {
            throw new GenerationException("We can only have a single @" + Arbiter.class.getSimpleName() + " per test.", element);
        }
        this.arbiter = element;
    }

    public void setResult(TypeElement element) {
        if (this.result != null && !this.result.equals(element)) {
            throw new GenerationException("We can only have a single @" + Result.class.getSimpleName() + " per test.", element);
        }
        this.result = element;
    }

    public void setTest(TypeElement element) {
        if (this.test != null && !this.test.equals(element)) {
            throw new GenerationException("We can only have a single test.", element);
        }
        this.test = element;
    }

    public void setSignal(ExecutableElement element) {
        if (this.signal != null && !this.signal.equals(element)) {
            throw new GenerationException("We can only have a single @" + Signal.class.getName() + " method.", element);
        }
        this.signal = element;
    }

    public TypeElement getState() {
        return this.state;
    }

    public TypeElement getResult() {
        return this.result;
    }

    public TypeElement getTest() {
        return this.test;
    }

    public List<ExecutableElement> getActors() {
        return this.actors;
    }

    public ExecutableElement getArbiter() {
        return this.arbiter;
    }

    public ExecutableElement getSignal() {
        return this.signal;
    }

    public void setGeneratedName(String generatedName) {
        this.generatedName = generatedName;
    }

    public String getGeneratedName() {
        return this.generatedName;
    }

    public void setRequiresFork(boolean requiresFork) {
        this.requiresFork = requiresFork;
    }

    public boolean isRequiresFork() {
        return this.requiresFork;
    }

    public void addCase(Outcome c) {
        if (c.desc().contains("\n")) {
            throw new GenerationException("Outcome descriptions can not contain line breaks.", this.test);
        }
        this.outcomes.add(c);
    }

    public Collection<Outcome> cases() {
        return this.outcomes;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addRef(String value) {
        this.refs.add(value);
    }

    public Collection<String> refs() {
        return this.refs;
    }
}

