/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.runners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openjdk.jcstress.infra.Status;
import org.openjdk.jcstress.infra.collectors.TestResult;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;
import org.openjdk.jcstress.infra.runners.Control;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.util.Counter;
import org.openjdk.jcstress.util.StringUtils;
import org.openjdk.jcstress.vm.WhiteBoxSupport;

public abstract class Runner<R> {
    protected static final int MIN_TIMEOUT_MS = 30000;
    protected final Control control;
    protected final TestResultCollector collector;
    protected final ExecutorService pool;
    protected final String testName;
    protected final TestConfig config;
    protected final List<String> messages;

    public Runner(TestConfig config, TestResultCollector collector, ExecutorService pool, String testName) {
        this.collector = collector;
        this.pool = pool;
        this.testName = testName;
        this.control = new Control();
        this.config = config;
        this.messages = new ArrayList<String>();
    }

    public void run() {
        try {
            this.dump(0, this.sanityCheck());
        }
        catch (ClassFormatError | NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError e) {
            this.dumpFailure(0, Status.API_MISMATCH, "Test sanity check failed, skipping", e);
            return;
        }
        catch (Throwable e) {
            this.dumpFailure(0, Status.CHECK_TEST_ERROR, "Check test failed", e);
            return;
        }
        for (int c = 1; c <= this.config.iters; ++c) {
            try {
                WhiteBoxSupport.tryDeopt(this.config.deoptRatio);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            this.dump(c, this.internalRun());
        }
    }

    private TestResult prepareResult(int iteration, Status status) {
        TestResult result = new TestResult(this.config, status, iteration);
        for (String msg : this.messages) {
            result.addAuxData(msg);
        }
        this.messages.clear();
        return result;
    }

    protected void dumpFailure(int iteration, Status status, String message) {
        this.messages.add(message);
        TestResult result = this.prepareResult(iteration, status);
        this.collector.add(result);
    }

    protected void dumpFailure(int iteration, Status status, String message, Throwable aux) {
        this.messages.add(message);
        TestResult result = this.prepareResult(iteration, status);
        result.addAuxData(StringUtils.getStacktrace(aux));
        this.collector.add(result);
    }

    protected void dump(int iteration, Counter<R> results) {
        TestResult result = this.prepareResult(iteration, Status.NORMAL);
        for (R e : results.elementSet()) {
            result.addState(String.valueOf(e), results.count(e));
        }
        this.collector.add(result);
    }

    public abstract Counter<R> sanityCheck() throws Throwable;

    public abstract Counter<R> internalRun();

    protected <T> void waitFor(Collection<Future<T>> tasks) {
        long startTime = System.nanoTime();
        boolean allStopped = false;
        while (!allStopped) {
            allStopped = true;
            for (Future<T> t : tasks) {
                try {
                    t.get(1L, TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    allStopped = false;
                }
                catch (ExecutionException e) {
                    this.dumpFailure(-1, Status.TEST_ERROR, "Unrecoverable error while running", e.getCause());
                    return;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            long timeSpent = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            if (timeSpent <= (long)Math.max(2 * this.config.time, 30000)) continue;
            this.dumpFailure(-1, Status.TIMEOUT_ERROR, "Timeout waiting for tasks to complete: " + timeSpent + " ms");
            return;
        }
    }
}

