/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.runners;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import jdk.internal.vm.annotation.Contended;
import org.openjdk.jcstress.infra.runners.SpinLoopStyle;

public class StateHolder<S, R> {
    @sun.misc.Contended(value="finals")
    @Contended(value="finals")
    public final boolean stopped;
    @sun.misc.Contended(value="finals")
    @Contended(value="finals")
    public final S[] ss;
    @sun.misc.Contended(value="finals")
    @Contended(value="finals")
    public final R[] rs;
    @sun.misc.Contended(value="finals")
    @Contended(value="finals")
    public final int countWorkers;
    @sun.misc.Contended(value="finals")
    @Contended(value="finals")
    public final SpinLoopStyle spinStyle;
    @sun.misc.Contended(value="flags")
    @Contended(value="flags")
    private volatile boolean notAllStarted;
    @sun.misc.Contended(value="flags")
    @Contended(value="flags")
    private volatile boolean notAllReady;
    @sun.misc.Contended(value="flags")
    @Contended(value="flags")
    private volatile boolean notAllFinished;
    @sun.misc.Contended(value="flags")
    @Contended(value="flags")
    private volatile boolean notUpdated;
    @sun.misc.Contended(value="flags")
    @Contended(value="flags")
    public volatile boolean updateStride;
    @sun.misc.Contended
    @Contended
    private volatile int started;
    @sun.misc.Contended
    @Contended
    private volatile int ready;
    @sun.misc.Contended
    @Contended
    private volatile int finished;
    @sun.misc.Contended
    @Contended
    private volatile int consumed;
    static final AtomicIntegerFieldUpdater<StateHolder> UPDATER_STARTED = AtomicIntegerFieldUpdater.newUpdater(StateHolder.class, "started");
    static final AtomicIntegerFieldUpdater<StateHolder> UPDATER_READY = AtomicIntegerFieldUpdater.newUpdater(StateHolder.class, "ready");
    static final AtomicIntegerFieldUpdater<StateHolder> UPDATER_FINISHED = AtomicIntegerFieldUpdater.newUpdater(StateHolder.class, "finished");
    static final AtomicIntegerFieldUpdater<StateHolder> UPDATER_CONSUMED = AtomicIntegerFieldUpdater.newUpdater(StateHolder.class, "consumed");

    public StateHolder(S[] states, R[] results, int expectedWorkers, SpinLoopStyle spinStyle) {
        this(false, states, results, expectedWorkers, spinStyle);
        this.updateStride = true;
    }

    public StateHolder(boolean stopped, S[] states, R[] results, int expectedWorkers, SpinLoopStyle spinStyle) {
        this.stopped = stopped;
        this.ss = states;
        this.rs = results;
        this.countWorkers = expectedWorkers;
        this.spinStyle = spinStyle;
        UPDATER_STARTED.set(this, expectedWorkers);
        UPDATER_READY.set(this, expectedWorkers);
        UPDATER_FINISHED.set(this, expectedWorkers);
        UPDATER_CONSUMED.set(this, expectedWorkers);
        this.notAllReady = true;
        this.notAllFinished = true;
        this.notAllStarted = true;
        this.notUpdated = true;
    }

    public void preRun() {
        int v = UPDATER_READY.decrementAndGet(this);
        if (v == 0) {
            this.notAllReady = false;
        }
        switch (this.spinStyle) {
            case THREAD_YIELD: {
                while (this.notAllReady) {
                    Thread.yield();
                }
                break;
            }
            case THREAD_SPIN_WAIT: {
                while (this.notAllReady) {
                    Thread.onSpinWait();
                }
                break;
            }
            default: {
                while (this.notAllReady) {
                }
                break block0;
            }
        }
        if (UPDATER_STARTED.decrementAndGet(this) == 0) {
            this.notAllStarted = false;
        }
    }

    public void postRun() {
        if (UPDATER_FINISHED.decrementAndGet(this) == 0) {
            this.notAllFinished = false;
        }
        this.updateStride |= this.notAllStarted;
        switch (this.spinStyle) {
            case THREAD_YIELD: {
                while (this.notAllFinished) {
                    Thread.yield();
                }
                break;
            }
            case THREAD_SPIN_WAIT: {
                while (this.notAllFinished) {
                    Thread.onSpinWait();
                }
                break;
            }
            default: {
                while (this.notAllFinished) {
                }
                break block0;
            }
        }
    }

    public boolean tryStartUpdate() {
        return UPDATER_CONSUMED.decrementAndGet(this) == 0;
    }

    public void finishUpdate() {
        this.notUpdated = false;
    }

    public void postUpdate() {
        switch (this.spinStyle) {
            case THREAD_YIELD: {
                while (this.notUpdated) {
                    Thread.yield();
                }
                break;
            }
            case THREAD_SPIN_WAIT: {
                while (this.notUpdated) {
                    Thread.onSpinWait();
                }
                break;
            }
            default: {
                while (this.notUpdated) {
                }
                break block0;
            }
        }
    }
}

