/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.runners;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.openjdk.jcstress.Options;
import org.openjdk.jcstress.infra.TestInfo;
import org.openjdk.jcstress.infra.runners.SpinLoopStyle;
import org.openjdk.jcstress.vm.AllocProfileSupport;

public class TestConfig
implements Serializable {
    public final SpinLoopStyle spinLoopStyle;
    public final boolean verbose;
    public final int time;
    public final int iters;
    public final int deoptRatio;
    public final int threads;
    public final String name;
    public final String generatedRunnerName;
    public final List<String> jvmArgs;
    public final RunMode runMode;
    public final int forkId;
    public final int maxFootprintMB;
    public int minStride;
    public int maxStride;
    public StrideCap strideCap;

    public TestConfig(Options opts, TestInfo info, RunMode runMode, int forkId, List<String> jvmArgs) {
        this.runMode = runMode;
        this.forkId = forkId;
        this.jvmArgs = jvmArgs;
        this.time = opts.getTime();
        this.minStride = opts.getMinStride();
        this.maxStride = opts.getMaxStride();
        this.iters = opts.getIterations();
        this.spinLoopStyle = opts.getSpinStyle();
        this.verbose = opts.isVerbose();
        this.deoptRatio = opts.deoptRatio();
        this.maxFootprintMB = opts.getMaxFootprintMb();
        this.threads = info.threads();
        this.name = info.name();
        this.generatedRunnerName = info.generatedRunner();
        this.strideCap = StrideCap.NONE;
    }

    public void adjustStrides(Consumer<Integer> tryAllocate) {
        int count;
        int succCount = count = 1;
        while (true) {
            StrideCap cap;
            if ((cap = this.tryWith(tryAllocate, count)) != StrideCap.NONE) {
                this.strideCap = cap;
                break;
            }
            succCount = count;
            if (succCount > this.maxStride) {
                succCount = this.maxStride;
                break;
            }
            count *= 2;
        }
        this.maxStride = Math.min(this.maxStride, succCount);
        this.minStride = Math.min(this.minStride, succCount);
    }

    private StrideCap tryWith(Consumer<Integer> tryAllocate, int count) {
        int TRIES = 10;
        for (int tries = 0; tries < 10; ++tries) {
            long startFoot = AllocProfileSupport.getAllocatedBytes();
            long startTime = System.nanoTime();
            try {
                tryAllocate.accept(count);
                long usedTime = System.nanoTime() - startTime;
                long footprint = AllocProfileSupport.getAllocatedBytes() - startFoot;
                if (footprint > (long)(this.maxFootprintMB * 1024 * 1024)) {
                    return StrideCap.FOOTPRINT;
                }
                if (TimeUnit.NANOSECONDS.toMillis(usedTime) <= (long)this.time) continue;
                return StrideCap.TIME;
            }
            catch (OutOfMemoryError err) {
                return StrideCap.FOOTPRINT;
            }
        }
        return StrideCap.NONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestConfig that = (TestConfig)o;
        if (this.spinLoopStyle != that.spinLoopStyle) {
            return false;
        }
        if (this.minStride != that.minStride) {
            return false;
        }
        if (this.maxStride != that.maxStride) {
            return false;
        }
        if (this.time != that.time) {
            return false;
        }
        if (this.iters != that.iters) {
            return false;
        }
        if (this.deoptRatio != that.deoptRatio) {
            return false;
        }
        if (this.threads != that.threads) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.jvmArgs.equals(that.jvmArgs)) {
            return false;
        }
        return this.runMode == that.runMode;
    }

    public int hashCode() {
        int result = this.spinLoopStyle.hashCode();
        result = 31 * result + this.minStride;
        result = 31 * result + this.maxStride;
        result = 31 * result + this.time;
        result = 31 * result + this.iters;
        result = 31 * result + this.deoptRatio;
        result = 31 * result + this.threads;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.jvmArgs.hashCode();
        result = 31 * result + this.runMode.hashCode();
        return result;
    }

    public String toString() {
        return "JVM options: " + this.jvmArgs + "\nIterations: " + this.iters + "\nTime: " + this.time + "\nStride: [" + this.minStride + ", " + this.maxStride + "] (capped by " + (Object)((Object)this.strideCap) + ")";
    }

    public static enum StrideCap {
        NONE,
        FOOTPRINT,
        TIME;

    }

    public static enum RunMode {
        EMBEDDED,
        FORKED;

    }
}

