/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.infra.runners;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.openjdk.jcstress.annotations.Expect;
import org.openjdk.jcstress.infra.StateCase;
import org.openjdk.jcstress.infra.TestInfo;
import org.openjdk.jcstress.util.TestLineReader;

public class TestList {
    public static final String LIST = "/META-INF/TestList";
    private static volatile Map<String, TestInfo> tests;

    private static Map<String, TestInfo> getTests() {
        if (tests == null) {
            HashMap<String, TestInfo> m = new HashMap<String, TestInfo>();
            InputStream stream = null;
            try {
                String line;
                stream = TestList.class.getResourceAsStream(LIST);
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                while ((line = reader.readLine()) != null) {
                    TestLineReader read = new TestLineReader(line);
                    if (!read.isCorrect()) continue;
                    String name = read.nextString();
                    String runner = read.nextString();
                    String description = read.nextString();
                    int actorCount = read.nextInt();
                    boolean requiresFork = read.nextBoolean();
                    int caseCount = read.nextInt();
                    TestInfo testInfo = new TestInfo(name, runner, description, actorCount, requiresFork);
                    m.put(name, testInfo);
                    for (int c = 0; c < caseCount; ++c) {
                        Expect expect = Expect.valueOf(read.nextString());
                        String desc = read.nextString();
                        int stateCount = read.nextInt();
                        for (int s = 0; s < stateCount; ++s) {
                            String regex = read.nextString();
                            Pattern pattern = Pattern.compile(regex);
                            testInfo.addCase(new StateCase(pattern, expect, desc));
                        }
                    }
                    int refCount = read.nextInt();
                    for (int c = 0; c < refCount; ++c) {
                        testInfo.addRef(read.nextString());
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Fatal error", e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            tests = m;
        }
        return tests;
    }

    public static Collection<String> tests() {
        return TestList.getTests().keySet();
    }

    public static TestInfo getInfo(String name) {
        TestInfo info = TestList.getTests().get(name);
        if (info == null) {
            throw new IllegalArgumentException("Unable to find info for test: " + name);
        }
        return info;
    }
}

