/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.link;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.openjdk.jcstress.infra.collectors.TestResult;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.link.JobRequestFrame;
import org.openjdk.jcstress.link.JobResponseFrame;
import org.openjdk.jcstress.link.ResultsFrame;

public final class BinaryLinkClient {
    private static final int LINK_TIMEOUT_MS = Integer.getInteger("jcstress.link.timeoutMs", 30000);
    private final Object lock;
    private final String hostName;
    private final int hostPort;

    public BinaryLinkClient(String hostName, int hostPort) throws IOException {
        this.hostName = hostName;
        this.hostPort = hostPort;
        this.lock = new Object();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object requestResponse(Object frame) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try (Socket socket = null;){
                socket = new Socket(this.hostName, this.hostPort);
                socket.setKeepAlive(true);
                socket.setSoTimeout(LINK_TIMEOUT_MS);
                ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
                oos.writeObject(frame);
                oos.flush();
                ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
                Object o = ois.readObject();
                oos.close();
                ois.close();
                Object object2 = o;
                return object2;
            }
        }
    }

    public TestConfig nextJob(String token) throws IOException, ClassNotFoundException {
        Object reply = this.requestResponse(new JobRequestFrame(token));
        if (reply instanceof JobResponseFrame) {
            return ((JobResponseFrame)reply).getConfig();
        }
        throw new IllegalStateException("Got the erroneous reply: " + reply);
    }

    public void addResult(String token, TestResult result) {
        try {
            this.requestResponse(new ResultsFrame(token, result));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

