/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.link;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.link.JobRequestFrame;
import org.openjdk.jcstress.link.JobResponseFrame;
import org.openjdk.jcstress.link.OkResponseFrame;
import org.openjdk.jcstress.link.ResultsFrame;
import org.openjdk.jcstress.link.ServerListener;
import org.openjdk.jcstress.link.WTFWasThatFrame;

public final class BinaryLinkServer {
    private static final String LINK_ADDRESS = System.getProperty("jcstress.link.address");
    private static final int LINK_PORT = Integer.getInteger("jcstress.link.port", 0);
    private static final int LINK_TIMEOUT_MS = Integer.getInteger("jcstress.link.timeoutMs", 30000);
    private final ServerSocket server;
    private final InetAddress listenAddress;
    private final Handler handler;
    private final ServerListener listener;

    public BinaryLinkServer(ServerListener listener) throws IOException {
        this.listener = listener;
        this.listenAddress = this.getListenAddress();
        this.server = new ServerSocket(LINK_PORT, 50, this.listenAddress);
        this.server.setSoTimeout(LINK_TIMEOUT_MS);
        this.handler = new Handler(this.server);
        this.handler.start();
    }

    private InetAddress getListenAddress() {
        if (LINK_ADDRESS != null) {
            try {
                return InetAddress.getByName(LINK_ADDRESS);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Can not initialize binary link.", e);
            }
        }
        return InetAddress.getLoopbackAddress();
    }

    public void terminate() {
        this.handler.interrupt();
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.handler.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getHost() {
        return this.listenAddress.getHostAddress();
    }

    public int getPort() {
        return this.server.getLocalPort();
    }

    private final class Handler
    extends Thread {
        private final ServerSocket server;

        public Handler(ServerSocket server) {
            this.server = server;
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                this.acceptAndProcess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acceptAndProcess() {
            Socket socket = null;
            try {
                socket = this.server.accept();
                ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
                Object obj = ois.readObject();
                ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
                if (obj instanceof JobRequestFrame) {
                    String tkn = ((JobRequestFrame)obj).getToken();
                    TestConfig cfg = BinaryLinkServer.this.listener.onJobRequest(tkn);
                    oos.writeObject(new JobResponseFrame(cfg));
                } else if (obj instanceof ResultsFrame) {
                    ResultsFrame rf = (ResultsFrame)obj;
                    BinaryLinkServer.this.listener.onResult(rf.getToken(), rf.getRes());
                    oos.writeObject(new OkResponseFrame());
                } else {
                    oos.writeObject(new WTFWasThatFrame());
                }
                oos.close();
                ois.close();
            }
            catch (EOFException eOFException) {
            }
            catch (Exception exception) {
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

