/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public final class Counter<R>
implements Serializable {
    private static final int RECIPROCAL_LOAD_FACTOR = 10;
    private static final int INITIAL_CAPACITY = 64;
    private Object[] keys;
    private long[] counts;
    private int length;
    private int keyCount;

    public Counter() {
        this(64);
    }

    public Counter(int len) {
        this.length = len;
        Object[] table = new Object[len];
        this.keys = table;
        this.counts = new long[len];
    }

    public final void record(R result) {
        this.record(result, 1L);
    }

    public final void record(R result, long count) {
        int idx = result.hashCode() & this.length - 1;
        Object k = this.keys[idx];
        while (k != null) {
            if (k.equals(result)) {
                int n = idx;
                this.counts[n] = this.counts[n] + count;
                return;
            }
            idx = idx + 1 & this.length - 1;
            k = this.keys[idx];
        }
        if (this.keyCount * 10 > this.length) {
            this.resize();
            this.record(result, count);
            return;
        }
        ++this.keyCount;
        this.keys[idx] = Counter.decouple(result);
        this.counts[idx] = count;
    }

    public final void merge(Counter<R> other) {
        for (R key : other.elementSet()) {
            this.record(key, other.count(key));
        }
    }

    private void resize() {
        Object[] prevKeys = this.keys;
        long[] prevCounts = this.counts;
        int newLen = this.length << 1;
        Object[] table = new Object[newLen];
        this.keys = table;
        this.counts = new long[newLen];
        this.length = newLen;
        for (int kIdx = 0; kIdx < prevKeys.length; ++kIdx) {
            Object k = prevKeys[kIdx];
            if (k == null) continue;
            int idx = k.hashCode() & this.length - 1;
            while (this.keys[idx] != null) {
                idx = idx + 1 & this.length - 1;
            }
            this.keys[idx] = k;
            this.counts[idx] = prevCounts[kIdx];
        }
    }

    public final long count(R result) {
        int idx = result.hashCode() & this.length - 1;
        while (this.keys[idx] != null) {
            if (this.keys[idx].equals(result)) {
                return this.counts[idx];
            }
            idx = idx + 1 & this.length - 1;
        }
        return 0L;
    }

    private static <T> T decouple(T result) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(result);
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object t = ois.readObject();
            return (T)t;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public final Collection<R> elementSet() {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Object k : this.keys) {
            if (k == null) continue;
            Object e = k;
            res.add(e);
        }
        return res;
    }
}

