/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public static <T extends Flushable & Closeable> void safelyClose(T obj) {
        if (obj != null) {
            try {
                obj.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                ((Closeable)obj).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static <T extends Closeable> void safelyClose(T obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyFileToTemp(String cpLocation, String prefix, String suffix) throws IOException {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = FileUtils.class.getResourceAsStream(cpLocation);
            if (is == null) {
                throw new IOException("Resource not found: " + cpLocation);
            }
            File file = File.createTempFile(prefix, suffix);
            os = new FileOutputStream(file);
            FileUtils.transferTo(is, os);
            String string = file.getAbsolutePath();
            return string;
        }
        finally {
            FileUtils.safelyClose(is);
            FileUtils.safelyClose(os);
        }
    }

    private static long transferTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long transferred = 0L;
        byte[] buffer = new byte[8192];
        while ((read = inputStream.read(buffer, 0, 8192)) >= 0) {
            outputStream.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }
}

