/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InputStreamDrainer
extends Thread {
    private static final int BUF_SIZE = 1024;
    private final OutputStream out;
    private final InputStream in;

    public InputStreamDrainer(InputStream in) {
        this(in, null);
    }

    public InputStreamDrainer(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public void run() {
        byte[] buf = new byte[1024];
        try {
            int read;
            while ((read = this.in.read(buf)) != -1) {
                if (this.out == null) continue;
                this.out.write(buf, 0, read);
            }
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ioe.getMessage(), ioe);
        }
        finally {
            try {
                this.in.close();
            }
            catch (IOException ioe) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ioe.getMessage(), ioe);
            }
        }
    }
}

