/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;

public class OptionFormatter
implements HelpFormatter {
    public String format(Map<String, ? extends OptionDescriptor> options) {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: java -jar jcstress.jar [options]");
        sb.append(System.lineSeparator());
        sb.append(" [opt] means optional argument.");
        sb.append(System.lineSeparator());
        sb.append(" <opt> means required argument.");
        sb.append(System.lineSeparator());
        sb.append(" \"+\" means comma-separated list of values.");
        sb.append(System.lineSeparator());
        sb.append(" \"time\" arguments accept time suffixes, like \"100ms\".");
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        for (OptionDescriptor optionDescriptor : options.values()) {
            if (optionDescriptor.options().contains("hostName") || optionDescriptor.options().contains("hostPort")) continue;
            sb.append(this.lineFor(optionDescriptor));
        }
        return sb.toString();
    }

    private Collection<String> rewrap(String lines) {
        ArrayList<String> result = new ArrayList<String>();
        String[] words = lines.split("[ \n\r]");
        String line = "";
        int cols = 0;
        for (String w : words) {
            if (cols + w.length() > 50) {
                result.add(line);
                line = w + " ";
                cols = w.length();
                continue;
            }
            cols += w.length();
            line = line + w + " ";
        }
        result.add(line);
        return result;
    }

    private String lineFor(OptionDescriptor d) {
        StringBuilder line = new StringBuilder();
        StringBuilder o = new StringBuilder();
        o.append("  ");
        for (String str : d.options()) {
            if (!d.representsNonOptions()) {
                o.append("-");
            }
            o.append(str);
            if (!d.acceptsArguments()) continue;
            o.append(" ");
            if (d.requiresArgument()) {
                o.append("<");
            } else {
                o.append("[");
            }
            o.append(d.argumentDescription());
            if (d.requiresArgument()) {
                o.append(">");
                continue;
            }
            o.append("]");
        }
        line.append(String.format("%-30s", o.toString()));
        boolean first = true;
        for (String l : this.rewrap(d.description())) {
            if (first) {
                first = false;
            } else {
                line.append(System.lineSeparator());
                line.append(String.format("%-30s", ""));
            }
            if (l.trim().isEmpty()) continue;
            line.append(l);
        }
        line.append(System.lineSeparator());
        line.append(System.lineSeparator());
        return line.toString();
    }
}

