/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;

public class Reflections {
    private static volatile boolean RESOURCE_INITED;
    private static Set<String> RESOURCES;

    private static void ensureResourceInited() throws IOException {
        if (!RESOURCE_INITED) {
            TreeSet<String> newResources = new TreeSet<String>();
            try {
                Reflections.enumerate(newResources::add);
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
            RESOURCES = newResources;
            RESOURCE_INITED = true;
        }
    }

    public static Collection<Class> getClasses(String filter) throws IOException {
        ArrayList<Class> newClasses = new ArrayList<Class>();
        for (String name : Reflections.getClassNames(filter)) {
            try {
                if (name.contains("sun.misc") || name.contains("jdk.internal")) continue;
                newClasses.add(Class.forName(name, false, Reflections.class.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (ClassFormatError | NoSuchFieldError | NoSuchMethodError linkageError) {
            }
        }
        return newClasses;
    }

    public static Collection<String> getClassNames(String filter) throws IOException {
        Reflections.ensureResourceInited();
        Pattern p = Pattern.compile("[\\\\|/]");
        ArrayList<String> newClasses = new ArrayList<String>();
        for (String name : RESOURCES) {
            if (!(name = p.matcher(name).replaceAll(".")).contains(filter) || !name.endsWith(".class")) continue;
            newClasses.add(name.substring(0, name.length() - 6));
        }
        return newClasses;
    }

    public static void enumerate(ResultCallback callback) throws Throwable {
        for (String element : System.getProperty("java.class.path").split(File.pathSeparator)) {
            Reflections.enumerate(callback, element);
        }
    }

    public static void enumerate(ResultCallback callback, String element) throws Throwable {
        File file = new File(element);
        if (file.getName().endsWith(".jar")) {
            Reflections.enumerateJAR(file, callback);
        } else {
            Reflections.enumeratePath(element, callback);
        }
    }

    private static void enumeratePath(String dir, ResultCallback callback) throws IOException {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(new File(dir));
        while (!dirs.isEmpty()) {
            ArrayList<File> siblings = new ArrayList<File>();
            for (File d : dirs) {
                for (File f : d.listFiles()) {
                    if (f.isDirectory()) {
                        siblings.add(f);
                    }
                    callback.accept(f.toString());
                }
            }
            dirs = siblings;
        }
    }

    private static void enumerateJAR(File jar, ResultCallback callback) throws Throwable {
        JarEntry jarEntry;
        FileInputStream jarFileStream = new FileInputStream(jar);
        JarInputStream jarFile = new JarInputStream(jarFileStream);
        while ((jarEntry = jarFile.getNextJarEntry()) != null) {
            callback.accept(jarEntry.getName());
        }
        jarFileStream.close();
        jarFile.close();
    }

    public static interface ResultCallback {
        public void accept(String var1);
    }
}

