/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StringUtils {
    public static String cutoff(String src, int len) {
        src = src.replaceAll("\u0000", " ");
        while (src.contains("  ")) {
            src = src.replaceAll("  ", " ");
        }
        String trim = src.replaceAll("\n", "").trim();
        if (trim.length() <= len) {
            return trim;
        }
        int min = Math.min(len - 3, trim.length());
        String substring = trim.substring(0, min);
        if (!substring.equals(trim)) {
            return substring + "...";
        }
        return substring;
    }

    public static Collection<String> splitQuotedEscape(String src) {
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (char ch : src.toCharArray()) {
            if (ch == ' ' && !escaped) {
                String s = sb.toString();
                if (s.isEmpty()) continue;
                results.add(s);
                sb = new StringBuilder();
                continue;
            }
            if (ch == '\"') {
                escaped ^= true;
                continue;
            }
            sb.append(ch);
        }
        String s = sb.toString();
        if (!s.isEmpty()) {
            results.add(s);
        }
        return results;
    }

    public static String chunkName(String name) {
        return name.replace("org.openjdk.jcstress.tests", "o.o.j.t");
    }

    public static String upcaseFirst(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private static boolean hasText(String s) {
        return s != null && !s.isEmpty();
    }

    public static String join(List<String> list, String delim) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String getStacktrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static String getFirstLine(String src) {
        int endLine = src.indexOf("\n");
        if (endLine > 0) {
            return src.substring(0, endLine).trim();
        }
        return src;
    }
}

