/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.util;

public class TestLineReader {
    private final String line;
    private final boolean correct;
    private int cursor;

    public TestLineReader(String line) {
        this.line = line;
        this.correct = line.length() > 6 && line.startsWith("JCTEST");
        this.cursor = 6;
    }

    private int readLen() {
        StringBuilder sb = new StringBuilder();
        char c = this.line.charAt(this.cursor);
        while (Character.isDigit(c)) {
            sb.append(c);
            ++this.cursor;
            c = this.line.charAt(this.cursor);
        }
        return Integer.valueOf(sb.toString());
    }

    private String readString(int len) {
        String s = this.line.substring(this.cursor, this.cursor + len);
        this.cursor += len;
        return s;
    }

    private char readChar() {
        return this.line.charAt(this.cursor++);
    }

    public String nextString() {
        int len = this.readLen();
        char tag = this.readChar();
        if (tag != 'S') {
            throw new IllegalStateException("expected tag = S, got = " + tag);
        }
        return this.readString(len);
    }

    public int nextInt() {
        int len = this.readLen();
        char tag = this.readChar();
        if (tag != 'I') {
            throw new IllegalStateException("expected tag = I, got = " + tag);
        }
        return Integer.valueOf(this.readString(len));
    }

    public boolean nextBoolean() {
        int len = this.readLen();
        char tag = this.readChar();
        if (tag != 'B') {
            throw new IllegalStateException("expected tag = B, got = " + tag);
        }
        char v = this.readChar();
        return v == 'T';
    }

    public boolean isCorrect() {
        return this.correct;
    }
}

