/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openjdk.jcstress.util.Multimap;

public class TreeMultimap<K, V>
implements Multimap<K, V>,
Serializable {
    private final Map<K, Collection<V>> map = new TreeMap<K, Collection<V>>();

    @Override
    public void put(K key, V value) {
        Collection<V> vs = this.map.get(key);
        if (vs == null) {
            vs = new ArrayList<V>();
            this.map.put(key, vs);
        }
        vs.add(value);
    }

    @Override
    public Collection<V> get(K key) {
        Collection<V> vs = this.map.get(key);
        return vs == null ? Collections.emptyList() : Collections.unmodifiableCollection(vs);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Collection<K> keys() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        for (Collection<V> vs : this.map.values()) {
            result.addAll(vs);
        }
        return result;
    }

    @Override
    public Collection<Collection<V>> valueGroups() {
        return this.map.values();
    }

    @Override
    public void remove(K key) {
        this.map.remove(key);
    }
}

