/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.vm;

import org.openjdk.jcstress.vm.AllocProfileSupport;

public class AllocProfileMain {
    static Object sink;

    public static void main(String ... args) {
        if (!AllocProfileSupport.isAvailable()) {
            System.out.println("Allocation profiling is not available!");
            System.exit(1);
        }
        for (int count : new int[]{1, 100, 10000, 1000000}) {
            long start = AllocProfileSupport.getAllocatedBytes();
            sink = new int[count];
            long footprint = AllocProfileSupport.getAllocatedBytes() - start;
            if (footprint >= (long)(4 * count) && footprint <= (long)(1000 + 4 * count)) continue;
            System.out.println("Allocation profiling is dysfunctional: new int[" + count + "] takes " + footprint + " bytes?");
            System.exit(1);
        }
    }
}

