/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.vm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AllocProfileSupport {
    private static final boolean ALLOC_AVAILABLE = AllocProfileSupport.tryInitAlloc();
    private static ThreadMXBean ALLOC_MX_BEAN;
    private static Method ALLOC_MX_BEAN_GETTER;

    private static boolean tryInitAlloc() {
        try {
            Class<?> internalIntf = Class.forName("com.sun.management.ThreadMXBean");
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            if (!internalIntf.isAssignableFrom(bean.getClass())) {
                Class<?> pmo = Class.forName("java.lang.management.PlatformManagedObject");
                Method m = ManagementFactory.class.getMethod("getPlatformMXBean", Class.class, pmo);
                bean = (ThreadMXBean)m.invoke(null, internalIntf);
                if (bean == null) {
                    throw new UnsupportedOperationException("No way to access private ThreadMXBean");
                }
            }
            ALLOC_MX_BEAN = bean;
            ALLOC_MX_BEAN_GETTER = internalIntf.getMethod("getThreadAllocatedBytes", long[].class);
            AllocProfileSupport.getAllocatedBytes(bean.getAllThreadIds());
            return true;
        }
        catch (Throwable e) {
            System.out.println("WARNING: Allocation profiling is not available: " + e.getMessage());
            return false;
        }
    }

    public static long getAllocatedBytes() {
        long[] threadIds = new long[]{Thread.currentThread().getId()};
        return AllocProfileSupport.getAllocatedBytes(threadIds)[0];
    }

    private static long[] getAllocatedBytes(long[] threadIds) {
        if (ALLOC_AVAILABLE) {
            try {
                return (long[])ALLOC_MX_BEAN_GETTER.invoke((Object)ALLOC_MX_BEAN, new Object[]{threadIds});
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        return new long[threadIds.length];
    }

    public static boolean isAvailable() {
        return ALLOC_AVAILABLE;
    }
}

