/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.vm;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.openjdk.jcstress.annotations.Result;
import org.openjdk.jcstress.util.Reflections;
import org.openjdk.jcstress.util.UnsafeHolder;

public class ContendedTestMain {
    private static final int PADDING_WIDTH = 64;

    public static void main(String ... args) throws NoSuchFieldException, IOException {
        ArrayList<String> msgs = new ArrayList<String>();
        Collection<Class> classes = Reflections.getClasses("class");
        if (classes.isEmpty()) {
            throw new IllegalStateException("Classes not found");
        }
        Set infraClasses = Collections.emptySet();
        for (Class cl : classes) {
            if (!infraClasses.contains(cl) && cl.getAnnotation(Result.class) == null) continue;
            ArrayList<FieldDef> fdefs = new ArrayList<FieldDef>();
            for (Field f : cl.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                fdefs.add(new FieldDef(f));
            }
            Collections.sort(fdefs);
            FieldDef last = null;
            for (FieldDef fd : fdefs) {
                if (fd.offset < 64L) {
                    msgs.add("Class " + cl + ": field " + fd.field.getName() + " is not padded");
                }
                if (last != null && Math.abs(fd.offset - last.offset) < 64L) {
                    msgs.add("Class " + cl + ": fields " + fd.field.getName() + " and " + last.field.getName() + " are not padded pairwise");
                }
                last = fd;
            }
        }
        if (!msgs.isEmpty()) {
            for (String msg : msgs) {
                System.out.println(msg);
            }
            throw new IllegalStateException("@Contended does not seem to work properly");
        }
    }

    static class FieldDef
    implements Comparable<FieldDef> {
        final Field field;
        final long offset;

        FieldDef(Field f) {
            this.field = f;
            this.offset = UnsafeHolder.U.objectFieldOffset(f);
        }

        @Override
        public int compareTo(FieldDef o) {
            return Long.compare(this.offset, o.offset);
        }
    }
}

