/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.vm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.openjdk.jcstress.Options;
import org.openjdk.jcstress.util.ArrayUtils;
import org.openjdk.jcstress.util.FileUtils;
import org.openjdk.jcstress.util.InputStreamDrainer;
import org.openjdk.jcstress.vm.AllocProfileMain;
import org.openjdk.jcstress.vm.ContendedTestMain;
import org.openjdk.jcstress.vm.DeoptTestMain;
import org.openjdk.jcstress.vm.SimpleTestMain;
import org.openjdk.jcstress.vm.ThreadSpinWaitTestMain;
import org.openjdk.jcstress.vm.VMSupportException;

public class VMSupport {
    private static final List<String> ADD_JVM_FLAGS = new ArrayList<String>();
    private static final Collection<Collection<String>> AVAIL_JVM_MODES = new ArrayList<Collection<String>>();
    private static volatile boolean THREAD_SPIN_WAIT_AVAILABLE;

    public static boolean spinWaitHintAvailable() {
        return THREAD_SPIN_WAIT_AVAILABLE;
    }

    public static void initFlags(Options opts) {
        System.out.println("Initializing and probing the target VM: ");
        System.out.println(" (all failures are non-fatal, but may affect testing accuracy)");
        System.out.println();
        VMSupport.detect("Unlocking diagnostic VM options", SimpleTestMain.class, "-XX:+UnlockDiagnosticVMOptions");
        int c = opts.getUserCPUs();
        VMSupport.detect("Trimming down the default VM heap size to 1/" + c + "-th of max RAM", SimpleTestMain.class, "-XX:MaxRAMFraction=" + c, "-XX:MinRAMFraction=" + c);
        VMSupport.detect("Trimming down the number of compiler threads", SimpleTestMain.class, "-XX:CICompilerCount=4");
        VMSupport.detect("Trimming down the number of parallel GC threads", SimpleTestMain.class, "-XX:ParallelGCThreads=4");
        VMSupport.detect("Trimming down the number of concurrent GC threads", SimpleTestMain.class, "-XX:ConcGCThreads=4");
        VMSupport.detect("Trimming down the number of G1 concurrent refinement GC threads", SimpleTestMain.class, "-XX:G1ConcRefinementThreads=4");
        VMSupport.detect("Testing @Contended works on all results and infra objects", ContendedTestMain.class, "-XX:-RestrictContended");
        try {
            String whiteBoxJarName = FileUtils.copyFileToTemp("/whitebox-api.jar", "whitebox", ".jar");
            VMSupport.detect("Unlocking Whitebox API for online de-optimization", DeoptTestMain.class, "-XX:+WhiteBoxAPI", "-Xbootclasspath/a:" + whiteBoxJarName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fatal error: WhiteBoxAPI JAR problems.", e);
        }
        VMSupport.detect("Testing allocation profiling", AllocProfileMain.class, new String[0]);
        THREAD_SPIN_WAIT_AVAILABLE = VMSupport.detect("Trying Thread.onSpinWait", ThreadSpinWaitTestMain.class, new String[0]);
        System.out.println();
    }

    private static boolean detect(String label, Class<?> mainClass, String ... opts) {
        try {
            String[] arguments = ArrayUtils.concat(opts, mainClass.getName());
            VMSupport.tryWith(arguments);
            ADD_JVM_FLAGS.addAll(Arrays.asList(opts));
            System.out.printf("----- %s %s%n", "[OK]", label);
            return true;
        }
        catch (VMSupportException ex) {
            System.out.printf("----- %s %s%n", "[FAILED]", label);
            System.out.println(ex.getMessage());
            return false;
        }
    }

    public static void detectAvailableVMModes(Collection<String> jvmArgs, Collection<String> jvmArgsPrepend) {
        Collection<Collection<String>> modes = jvmArgs != null ? Collections.singleton(jvmArgs) : Arrays.asList(Arrays.asList("-Xint"), Arrays.asList("-XX:TieredStopAtLevel=1"), Collections.emptyList(), Arrays.asList("-XX:+UnlockDiagnosticVMOptions", "-XX:+StressLCM", "-XX:+StressGCM"), Arrays.asList("-XX:-TieredCompilation"), Arrays.asList("-XX:-TieredCompilation", "-XX:+UnlockDiagnosticVMOptions", "-XX:+StressLCM", "-XX:+StressGCM"));
        if (jvmArgsPrepend != null) {
            modes = modes.stream().map(c -> {
                ArrayList l = new ArrayList();
                l.addAll(jvmArgsPrepend);
                l.addAll(c);
                return l;
            }).collect(Collectors.toList());
        }
        System.out.println("Probing what VM modes are available:");
        System.out.println(" (failures are non-fatal, but may miss some interesting cases)");
        System.out.println();
        for (Collection<String> mode : modes) {
            try {
                ArrayList<String> line = new ArrayList<String>(mode);
                line.add(SimpleTestMain.class.getName());
                VMSupport.tryWith(line.toArray(new String[0]));
                AVAIL_JVM_MODES.add(mode);
                System.out.printf("----- [OK] %s%n", mode);
            }
            catch (VMSupportException e) {
                System.out.printf("----- [N/A] %s%n", mode);
                System.out.println(e.getMessage());
                System.out.println();
            }
        }
        System.out.println();
    }

    public static void tryWith(String ... lines) throws VMSupportException {
        try {
            List<String> commandString = VMSupport.getJavaInvokeLine();
            commandString.addAll(Arrays.stream(lines).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
            ProcessBuilder pb = new ProcessBuilder(commandString);
            Process p = pb.start();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), baos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), baos);
            errDrainer.start();
            outDrainer.start();
            int ecode = p.waitFor();
            errDrainer.join();
            outDrainer.join();
            if (ecode != 0) {
                String msg = new String(baos.toByteArray());
                throw new VMSupportException(msg);
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new VMSupportException(ex.getMessage());
        }
    }

    public static List<String> getJavaInvokeLine() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(VMSupport.getDefaultJvm());
        command.add("-cp");
        if (VMSupport.isWindows()) {
            command.add('\"' + System.getProperty("java.class.path") + '\"');
        } else {
            command.add(System.getProperty("java.class.path"));
        }
        command.addAll(ADD_JVM_FLAGS);
        return command;
    }

    private static String getDefaultJvm() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" + (VMSupport.isWindows() ? ".exe" : "");
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").contains("indows");
    }

    public static Collection<Collection<String>> getAvailableVMModes() {
        return AVAIL_JVM_MODES;
    }

    public static int figureOutHotCPUs() {
        ExecutorService service = Executors.newCachedThreadPool();
        System.out.print("Burning up to figure out the exact CPU count...");
        int warmupTime = 1000;
        long lastChange = System.currentTimeMillis();
        ArrayList futures = new ArrayList();
        futures.add(service.submit(new BurningTask()));
        System.out.print(".");
        int max = 0;
        while (System.currentTimeMillis() - lastChange < (long)warmupTime) {
            int cur = Runtime.getRuntime().availableProcessors();
            if (cur <= max) continue;
            System.out.print(".");
            max = cur;
            lastChange = System.currentTimeMillis();
            futures.add(service.submit(new BurningTask()));
        }
        for (Future future : futures) {
            System.out.print(".");
            future.cancel(true);
        }
        service.shutdown();
        System.out.println(" done!");
        System.out.println();
        return max;
    }

    static class BurningTask
    implements Runnable {
        BurningTask() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
            }
        }
    }
}

