/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.vm;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.openjdk.jcstress.util.Reflections;
import sun.hotspot.WhiteBox;

public class WhiteBoxSupport {
    private static WhiteBox whiteBox;
    private static volatile boolean tried;
    private static volatile Mode mode;
    private static volatile Collection<Method> infraMethods;

    public static void init() throws Throwable {
        if (tried) {
            return;
        }
        try {
            WhiteBoxSupport.initAndTest();
        }
        finally {
            tried = true;
        }
    }

    private static void initAndTest() {
        WhiteBox.registerNatives();
        WhiteBox w = new WhiteBox();
        Throwable deoptMethod = null;
        try {
            w.deoptimizeMethod((Executable)WhiteBoxSupport.class.getMethod("initSafely", new Class[0]));
            w.isClassAlive(WhiteBoxSupport.class.getName());
        }
        catch (Throwable ex) {
            deoptMethod = ex;
        }
        Throwable deoptAll = null;
        try {
            w.deoptimizeAll();
        }
        catch (Throwable ex) {
            deoptAll = ex;
        }
        if (deoptMethod == null) {
            mode = Mode.DEOPT_METHOD;
        } else if (deoptAll == null) {
            mode = Mode.DEOPT_ALL;
        } else {
            IllegalStateException whiteBoxFailed = new IllegalStateException();
            whiteBoxFailed.addSuppressed(deoptAll);
            whiteBoxFailed.addSuppressed(deoptMethod);
            throw whiteBoxFailed;
        }
        whiteBox = w;
    }

    public static void initSafely() {
        if (tried) {
            return;
        }
        try {
            WhiteBoxSupport.initAndTest();
        }
        catch (Throwable throwable) {
        }
        finally {
            tried = true;
        }
    }

    public static void tryDeopt(int actionProbRatio) {
        WhiteBox w = whiteBox;
        if (w != null) {
            if (ThreadLocalRandom.current().nextInt(actionProbRatio) != 0) {
                return;
            }
            switch (mode) {
                case DEOPT_ALL: {
                    w.deoptimizeAll();
                    break;
                }
                case DEOPT_METHOD: {
                    try {
                        for (Method m : WhiteBoxSupport.getJCStressMethods()) {
                            w.deoptimizeMethod((Executable)m);
                        }
                        break;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException();
                    }
                }
                default: {
                    throw new IllegalStateException("Unknown deopt mode: " + (Object)((Object)mode));
                }
            }
        }
    }

    private static Collection<Method> getJCStressMethods() throws IOException {
        Collection<Method> im = infraMethods;
        if (im == null) {
            im = new ArrayList<Method>();
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(Reflections.getClassNames("org.openjdk.jcstress"));
            for (String name : names) {
                if (!whiteBox.isClassAlive(name)) continue;
                try {
                    Class<?> aClass = Class.forName(name);
                    Collections.addAll(im, aClass.getDeclaredMethods());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException();
                }
            }
            infraMethods = im;
        }
        return im;
    }

    static enum Mode {
        DEOPT_ALL,
        DEOPT_METHOD;

    }
}

