/*
 * Decompiled with CFR 0.152.
 */
package org.openkoreantext.processor;

import java.util.LinkedList;
import java.util.List;
import org.openkoreantext.processor.KoreanPosJava;
import org.openkoreantext.processor.KoreanTokenJava;
import org.openkoreantext.processor.OpenKoreanTextProcessor;
import org.openkoreantext.processor.phrase_extractor.KoreanPhraseExtractor;
import org.openkoreantext.processor.tokenizer.KoreanTokenizer;
import org.openkoreantext.processor.tokenizer.Sentence;
import org.openkoreantext.processor.util.KoreanPos;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public final class OpenKoreanTextProcessorJava {
    public static CharSequence normalize(CharSequence text) {
        return OpenKoreanTextProcessor.normalize(text);
    }

    public static Seq<KoreanTokenizer.KoreanToken> tokenize(CharSequence text) {
        return OpenKoreanTextProcessor.tokenize(text);
    }

    public static void addNounsToDictionary(List<String> words) {
        OpenKoreanTextProcessor.addNounsToDictionary((Seq<String>)JavaConversions.asScalaBuffer(words));
    }

    public static List<KoreanTokenJava> tokensToJavaKoreanTokenList(Seq<KoreanTokenizer.KoreanToken> tokens, boolean keepSpace) {
        Iterator tokenized = tokens.iterator();
        LinkedList<KoreanTokenJava> output = new LinkedList<KoreanTokenJava>();
        while (tokenized.hasNext()) {
            KoreanTokenizer.KoreanToken token = (KoreanTokenizer.KoreanToken)tokenized.next();
            if (!keepSpace && token.pos() == KoreanPos.Space()) continue;
            output.add(new KoreanTokenJava(token.text(), KoreanPosJava.valueOf(token.pos().toString()), token.offset(), token.length(), token.unknown()));
        }
        return output;
    }

    public static List<KoreanTokenJava> tokensToJavaKoreanTokenList(Seq<KoreanTokenizer.KoreanToken> tokens) {
        return OpenKoreanTextProcessorJava.tokensToJavaKoreanTokenList(tokens, false);
    }

    public static List<String> tokensToJavaStringList(Seq<KoreanTokenizer.KoreanToken> tokens, boolean keepSpace) {
        Iterator tokenized = tokens.iterator();
        LinkedList<String> output = new LinkedList<String>();
        while (tokenized.hasNext()) {
            KoreanTokenizer.KoreanToken token = (KoreanTokenizer.KoreanToken)tokenized.next();
            if (!keepSpace && token.pos() == KoreanPos.Space()) continue;
            output.add(token.text());
        }
        return output;
    }

    public static List<String> tokensToJavaStringList(Seq<KoreanTokenizer.KoreanToken> tokens) {
        return OpenKoreanTextProcessorJava.tokensToJavaStringList(tokens, false);
    }

    public static Seq<KoreanTokenizer.KoreanToken> stem(Seq<KoreanTokenizer.KoreanToken> tokens) {
        return OpenKoreanTextProcessor.stem(tokens);
    }

    public static List<Sentence> splitSentences(CharSequence text) {
        return JavaConversions.seqAsJavaList(OpenKoreanTextProcessor.splitSentences(text));
    }

    public static List<KoreanPhraseExtractor.KoreanPhrase> extractPhrases(Seq<KoreanTokenizer.KoreanToken> tokens, boolean filterSpam, boolean includeHashtags) {
        return JavaConversions.seqAsJavaList(OpenKoreanTextProcessor.extractPhrases(tokens, filterSpam, includeHashtags));
    }

    public static String detokenize(List<String> tokens) {
        return OpenKoreanTextProcessor.detokenize((Iterable<String>)JavaConversions.iterableAsScalaIterable(tokens));
    }
}

