/*
 * Decompiled with CFR 0.152.
 */
package org.openkoreantext.processor.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openkoreantext.processor.util.CharArrayMap;

public class CharArraySet
extends AbstractSet<Object> {
    private static final CharArraySet EMPTY_SET = new CharArraySet(CharArrayMap.emptyMap());
    private static final Object PLACEHOLDER = new Object();
    private final CharArrayMap<Object> map;

    public CharArraySet(int startSize) {
        this(new CharArrayMap<Object>(startSize));
    }

    private CharArraySet(Collection<?> c) {
        this(c.size());
        this.addAll(c);
    }

    CharArraySet(CharArrayMap<Object> map) {
        this.map = map;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public boolean contains(char[] text, int off, int len) {
        return this.map.containsKey(text, off, len);
    }

    public boolean contains(CharSequence cs) {
        return this.map.containsKey(cs);
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(Object o) {
        return this.map.put(o, PLACEHOLDER) == null;
    }

    @Override
    public boolean add(CharSequence text) {
        return this.map.put(text, PLACEHOLDER) == null;
    }

    @Override
    public boolean add(String text) {
        return this.map.put(text, PLACEHOLDER) == null;
    }

    @Override
    public boolean add(char[] text) {
        return this.map.put(text, PLACEHOLDER) == null;
    }

    public boolean remove(String text) {
        this.map.remove(text);
        return !this.map.containsKey(text);
    }

    @Override
    public boolean removeAll(List<String> words) {
        boolean removed = false;
        for (String word : words) {
            removed |= this.remove(word);
        }
        return removed;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public static CharArraySet unmodifiableSet(CharArraySet set) {
        if (set == null) {
            throw new NullPointerException("Given set is null");
        }
        if (set == EMPTY_SET) {
            return EMPTY_SET;
        }
        if (set.map instanceof CharArrayMap.UnmodifiableCharArrayMap) {
            return set;
        }
        return new CharArraySet(CharArrayMap.unmodifiableMap(set.map));
    }

    public static CharArraySet copy(Set<?> set) {
        if (set == EMPTY_SET) {
            return EMPTY_SET;
        }
        if (set instanceof CharArraySet) {
            CharArraySet source = (CharArraySet)set;
            return new CharArraySet(CharArrayMap.copy(source.map));
        }
        return new CharArraySet(set);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.map.originalKeySet().iterator();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (Object item : this) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            if (item instanceof char[]) {
                sb.append((char[])item);
                continue;
            }
            sb.append(item);
        }
        return sb.append(']').toString();
    }
}

