/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.engine;

import java.util.List;
import org.openksavi.sponge.ProcessorAdapter;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.correlator.CorrelatorAdapterGroup;
import org.openksavi.sponge.engine.ConfigurationManager;
import org.openksavi.sponge.engine.EngineModule;
import org.openksavi.sponge.engine.EngineParameters;
import org.openksavi.sponge.engine.EventQueueManager;
import org.openksavi.sponge.engine.ExceptionHandler;
import org.openksavi.sponge.engine.KnowledgeBaseManager;
import org.openksavi.sponge.engine.OnShutdownListener;
import org.openksavi.sponge.engine.OnStartupListener;
import org.openksavi.sponge.engine.PluginManager;
import org.openksavi.sponge.engine.ProcessingUnitManager;
import org.openksavi.sponge.engine.ProcessorManager;
import org.openksavi.sponge.engine.StatisticsManager;
import org.openksavi.sponge.engine.ThreadPoolManager;
import org.openksavi.sponge.engine.event.EventScheduler;
import org.openksavi.sponge.engine.processing.EventSetProcessorDurationStrategy;
import org.openksavi.sponge.filter.FilterAdapter;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.KnowledgeBaseFileProvider;
import org.openksavi.sponge.plugin.Plugin;
import org.openksavi.sponge.rule.RuleAdapterGroup;
import org.openksavi.sponge.spi.EngineModuleProvider;
import org.openksavi.sponge.spi.EventQueueProvider;
import org.openksavi.sponge.spi.KnowledgeBaseInterpreterFactoryProvider;
import org.openksavi.sponge.spi.ProcessingUnitProvider;
import org.openksavi.sponge.trigger.TriggerAdapter;
import org.openksavi.sponge.util.PatternMatcher;

public interface Engine
extends EngineModule {
    @Override
    public String getName();

    public void init();

    public PluginManager getPluginManager();

    public KnowledgeBaseManager getKnowledgeBaseManager();

    public ConfigurationManager getConfigurationManager();

    public ProcessingUnitManager getProcessingUnitManager();

    public EventQueueManager getEventQueueManager();

    public EventScheduler getEventScheduler();

    public ThreadPoolManager getThreadPoolManager();

    public ProcessorManager getProcessorManager();

    public StatisticsManager getStatisticsManager();

    public List<FilterAdapter> getFilters();

    public List<TriggerAdapter> getTriggers();

    public List<RuleAdapterGroup> getRuleGroups();

    public List<CorrelatorAdapterGroup> getCorrelatorGroups();

    public List<ActionAdapter> getActions();

    public void handleError(ProcessorAdapter<?> var1, Throwable var2);

    public void handleError(String var1, Throwable var2);

    public List<Plugin> getPlugins();

    public void reload();

    public void requestReload();

    public String getVersion();

    public String getDescription();

    public void requestShutdown();

    public boolean isError();

    public Throwable getError();

    public KnowledgeBaseEngineOperations getOperations();

    public KnowledgeBaseFileProvider getKnowledgeBaseFileProvider();

    public void addOnStartupListener(OnStartupListener var1);

    public List<OnStartupListener> getOnStartupListeners();

    public boolean removeOnStartupListener(OnStartupListener var1);

    public void addOnShutdownListener(OnShutdownListener var1);

    public List<OnShutdownListener> getOnShutdownListeners();

    public boolean removeOnShutdownListener(OnShutdownListener var1);

    public ExceptionHandler getExceptionHandler();

    public void setExceptionHandler(ExceptionHandler var1);

    public EngineParameters getDefaultParameters();

    public void setConfigurationFilename(String var1);

    public void setProcessingUnitProvider(ProcessingUnitProvider var1);

    public void setKnowledgeBaseInterpreterFactoryProviders(List<KnowledgeBaseInterpreterFactoryProvider> var1);

    public void setModuleProvider(EngineModuleProvider var1);

    public void setEventQueueProvider(EventQueueProvider var1);

    public void setKnowledgeBaseFileProvider(KnowledgeBaseFileProvider var1);

    public EventSetProcessorDurationStrategy getEventSetProcessorDurationStrategy();

    public void setEventSetProcessorDurationStrategy(EventSetProcessorDurationStrategy var1);

    public PatternMatcher getPatternMatcher();

    public void setPatternMatcher(PatternMatcher var1);
}

