/*
 * Copyright 2016-2017 The Sponge authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.openksavi.sponge.spi;

import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseInterpreter;
import org.openksavi.sponge.kb.KnowledgeBaseType;

/**
 * Knowledge base interpreter factory.
 */
public interface KnowledgeBaseInterpreterFactory {

    /**
     * Returns a knowledge base type supported by this factory.
     *
     * @return a knowledge base type.
     */
    KnowledgeBaseType getSupportedType();

    /**
     * Creates a new knowledge base interpreter.
     *
     * @param engine an engine.
     * @param knowledgeBase a knowledge base.
     * @return a new knowledge base interpreter.
     */
    KnowledgeBaseInterpreter createKnowledgeBaseInterpreter(Engine engine, KnowledgeBase knowledgeBase);
}
